/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.bridge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.core.AbstractUnoccupiedSpaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.bridge.BridgeFurniture;
import org.citygml4j.core.model.bridge.BridgeFurnitureProperty;
import org.citygml4j.core.model.bridge.BridgeInstallation;
import org.citygml4j.core.model.bridge.BridgeInstallationProperty;
import org.citygml4j.core.model.bridge.BridgeRoom;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.bridge.DeprecatedPropertiesOfBridgeRoom;

@CityJSONElements(value={@CityJSONElement(name="BridgeRoom", schema="CityJSON-Core", version=CityJSONVersion.v2_0), @CityJSONElement(name="BridgeRoom", schema="CityJSON-Core", version=CityJSONVersion.v1_1)})
public class BridgeRoomAdapter
extends AbstractUnoccupiedSpaceAdapter<BridgeRoom> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID);

    @Override
    public BridgeRoom createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new BridgeRoom();
    }

    @Override
    public void buildObject(BridgeRoom object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        block8: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "BridgeInstallation": {
                    object.getBridgeInstallations().add(new BridgeInstallationProperty(helper.getCityObject(child, BridgeInstallation.class)));
                    break;
                }
                case "BridgeFurniture": {
                    object.getBridgeFurniture().add(new BridgeFurnitureProperty(helper.getCityObject(child, BridgeFurniture.class)));
                    break;
                }
                default: {
                    continue block8;
                }
            }
            children.remove();
        }
    }

    @Override
    public String createType(BridgeRoom object, CityJSONVersion version) throws CityJSONSerializeException {
        return "BridgeRoom";
    }

    @Override
    public void writeObject(BridgeRoom object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetBridgeInstallations()) {
            for (BridgeInstallationProperty property : object.getBridgeInstallations()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BridgeInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBridgeFurniture()) {
            for (BridgeInstallationProperty property : object.getBridgeFurniture()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BridgeFurniture)property.getObject(), (AbstractFeature)object, node);
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(BridgeRoom object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfBridgeRoom properties = object.getDeprecatedProperties();
            return Map.of(4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfBridgeRoom)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfBridgeRoom)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

