/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.building;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import org.citygml4j.cityjson.adapter.core.AbstractLogicalSpaceAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.building.AbstractBuildingSubdivision;
import org.citygml4j.core.model.building.BuildingConstructiveElement;
import org.citygml4j.core.model.building.BuildingConstructiveElementProperty;
import org.citygml4j.core.model.building.BuildingFurniture;
import org.citygml4j.core.model.building.BuildingFurnitureProperty;
import org.citygml4j.core.model.building.BuildingInstallation;
import org.citygml4j.core.model.building.BuildingInstallationProperty;
import org.citygml4j.core.model.building.BuildingRoom;
import org.citygml4j.core.model.building.BuildingRoomProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.StandardObjectClassifier;

public abstract class AbstractBuildingSubdivisionAdapter<T extends AbstractBuildingSubdivision>
extends AbstractLogicalSpaceAdapter<T> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID);

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        JsonNode sortKey = attributes.consume("sortKey");
        if (sortKey.isNumber()) {
            object.setSortKey(Double.valueOf(sortKey.asDouble()));
        }
        Iterator children = node.path("children").elements();
        block12: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "BuildingInstallation": {
                    object.getBuildingInstallations().add(new BuildingInstallationProperty(helper.getCityObject(child, BuildingInstallation.class)));
                    break;
                }
                case "BuildingConstructiveElement": {
                    object.getBuildingConstructiveElements().add(new BuildingConstructiveElementProperty(helper.getCityObject(child, BuildingConstructiveElement.class)));
                    break;
                }
                case "BuildingRoom": {
                    object.getBuildingRooms().add(new BuildingRoomProperty(helper.getCityObject(child, BuildingRoom.class)));
                    break;
                }
                case "BuildingFurniture": {
                    object.getBuildingFurniture().add(new BuildingFurnitureProperty(helper.getCityObject(child, BuildingFurniture.class)));
                    break;
                }
                default: {
                    continue block12;
                }
            }
            children.remove();
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.getSortKey() != null) {
            attributes.put("sortKey", object.getSortKey());
        }
        if (object.isSetBuildingConstructiveElements()) {
            for (BuildingConstructiveElementProperty property : object.getBuildingConstructiveElements()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingConstructiveElement)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBuildingInstallations()) {
            for (BuildingConstructiveElementProperty property : object.getBuildingInstallations()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBuildingRooms()) {
            for (BuildingConstructiveElementProperty property : object.getBuildingRooms()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingRoom)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBuildingFurniture()) {
            for (BuildingConstructiveElementProperty property : object.getBuildingFurniture()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BuildingFurniture)property.getObject(), (AbstractFeature)object, node);
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }
}

