/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.cityobjectgroup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import org.citygml4j.cityjson.adapter.core.AbstractLogicalSpaceAdapter;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.cityobjectgroup.Role;
import org.citygml4j.core.model.cityobjectgroup.RoleProperty;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractCityObjectReference;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.cityobjectgroup.DeprecatedPropertiesOfCityObjectGroup;
import org.citygml4j.core.model.deprecated.cityobjectgroup.GroupMember;

@CityJSONElements(value={@CityJSONElement(name="CityObjectGroup", schema="CityJSON-Core", version=CityJSONVersion.v2_0), @CityJSONElement(name="CityObjectGroup", schema="CityJSON-Core", version=CityJSONVersion.v1_1), @CityJSONElement(name="CityObjectGroup", schema="CityJSON-Core", version=CityJSONVersion.v1_0)})
public class CityObjectGroupAdapter
extends AbstractLogicalSpaceAdapter<CityObjectGroup> {
    private final EnumSet<GeometryType> allowedTypes = EnumSet.complementOf(EnumSet.of(GeometryType.TEMPLATE_GEOMETRY));

    @Override
    public CityObjectGroup createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new CityObjectGroup();
    }

    @Override
    public void buildObject(CityObjectGroup object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        Iterator children = node.path("children").elements();
        JsonNode roles = attributes.consume("children_roles");
        int index = 0;
        while (children.hasNext()) {
            this.addGroupMember(object, ((JsonNode)children.next()).asText(), roles.get(index), helper);
            children.remove();
            ++index;
        }
        for (JsonNode member : attributes.consume("members")) {
            this.addGroupMember(object, member.asText(), null, helper);
        }
    }

    @Override
    public String createType(CityObjectGroup object, CityJSONVersion version) throws CityJSONSerializeException {
        return "CityObjectGroup";
    }

    @Override
    public void writeObject(CityObjectGroup object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetGroupMembers()) {
            for (Object property : object.getGroupMembers()) {
                if (property.getObject() == null || ((Role)property.getObject()).getGroupMember() == null || ((Role)property.getObject()).getGroupMember().getHref() == null) continue;
                AbstractCityObjectReference reference = ((Role)property.getObject()).getGroupMember();
                this.addChild(this.getIdFromReference(reference.getHref()), ((Role)property.getObject()).getRole(), node, helper);
            }
        }
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfCityObjectGroup properties = object.getDeprecatedProperties();
            if (properties.isSetGroupMembers()) {
                for (GroupMember member : properties.getGroupMembers()) {
                    if (member.getObject() == null) continue;
                    AbstractCityObject child = (AbstractCityObject)member.getObject();
                    helper.writeCityObject(child);
                    this.addChild(child.getId(), member.getRole(), node, helper);
                }
            }
            if (properties.getGroupParent() != null) {
                helper.writeCityObject((AbstractCityObject)properties.getGroupParent().getObject());
            }
            if (properties.getGeometry() != null) {
                helper.addGeometry(properties.getGeometry(), (Number)0, node);
            }
        }
        if (helper.getVersion() == CityJSONVersion.v1_0) {
            ArrayNode geometry = helper.getOrPutArray("geometry", node);
            if (geometry.size() > 1) {
                JsonNode element = geometry.get(0);
                geometry.removeAll().add(element);
            }
        } else if (this.containsOnlyNull((ArrayNode)node.get("children_roles"))) {
            node.remove("children_roles");
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    private void addGroupMember(CityObjectGroup object, String member, JsonNode memberRole, CityJSONBuilderHelper helper) {
        if (!member.isEmpty()) {
            helper.buildAsTopLevelObject(member);
            Role role = new Role(new AbstractCityObjectReference("#" + member));
            if (memberRole != null && memberRole.isTextual()) {
                role.setRole(memberRole.asText());
            }
            object.getGroupMembers().add(new RoleProperty(role));
        }
    }

    private void addChild(String id, String role, ObjectNode node, CityJSONSerializerHelper helper) {
        helper.getOrPutArray(helper.getVersion() == CityJSONVersion.v1_0 ? "members" : "children", node).add(id);
        if (helper.getVersion() != CityJSONVersion.v1_0) {
            helper.getOrPutArray("children_roles", node).add(role);
        }
    }

    private boolean containsOnlyNull(ArrayNode roles) {
        if (roles == null) {
            return false;
        }
        for (int i = 0; i < roles.size(); ++i) {
            if (roles.get(i).isNull()) continue;
            return false;
        }
        return true;
    }

    public String getIdFromReference(String reference) {
        int index = reference.lastIndexOf("#");
        return index != -1 ? reference.substring(index + 1) : reference;
    }
}

