/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.construction;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import org.citygml4j.cityjson.adapter.core.AbstractOccupiedSpaceAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.construction.AbstractConstruction;
import org.citygml4j.core.model.construction.ConditionOfConstructionValue;
import org.citygml4j.core.model.construction.Height;
import org.citygml4j.core.model.construction.HeightProperty;
import org.citygml4j.core.model.construction.HeightStatusValue;
import org.xmlobjects.gml.model.measures.Length;

public abstract class AbstractConstructionAdapter<T extends AbstractConstruction>
extends AbstractOccupiedSpaceAdapter<T> {
    private DateTimeFormatter localDateParser;

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode dateOfConstruction;
        super.buildObject(object, attributes, node, parent, helper);
        CityJSONVersion version = helper.getVersion();
        JsonNode conditionOfConstruction = attributes.consume("conditionOfConstruction");
        if (conditionOfConstruction.isTextual()) {
            object.setConditionOfConstruction(ConditionOfConstructionValue.fromValue((String)conditionOfConstruction.asText()));
        }
        if ((dateOfConstruction = attributes.consume(version == CityJSONVersion.v1_0 ? "yearOfConstruction" : "dateOfConstruction")).isTextual()) {
            object.setDateOfConstruction(this.toLocalDate(dateOfConstruction.asText()));
        } else if (dateOfConstruction.isInt()) {
            object.setDateOfConstruction(this.toLocalDate(dateOfConstruction.asInt()));
        }
        JsonNode dateOfDemolition = attributes.consume(version == CityJSONVersion.v1_0 ? "yearOfDemolition" : "dateOfDemolition");
        if (dateOfDemolition.isTextual()) {
            object.setDateOfDemolition(this.toLocalDate(dateOfDemolition.asText()));
        } else if (dateOfDemolition.isInt()) {
            object.setDateOfDemolition(this.toLocalDate(dateOfDemolition.asInt()));
        }
        JsonNode measuredHeight = attributes.consume("measuredHeight");
        if (measuredHeight.isNumber()) {
            object.getHeights().add(new HeightProperty(Height.ofMeasuredHeight((Length)new Length(Double.valueOf(measuredHeight.doubleValue()), "m"))));
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        CityJSONVersion version = helper.getVersion();
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getConditionOfConstruction() != null) {
            attributes.put("conditionOfConstruction", object.getConditionOfConstruction().toValue());
        }
        if (object.getDateOfConstruction() != null) {
            if (version == CityJSONVersion.v1_0) {
                attributes.put("yearOfConstruction", object.getDateOfConstruction().getYear());
            } else {
                attributes.put("dateOfConstruction", object.getDateOfConstruction().format(DateTimeFormatter.ISO_LOCAL_DATE));
            }
        }
        if (object.getDateOfDemolition() != null) {
            if (version == CityJSONVersion.v1_0) {
                attributes.put("yearOfDemolition", object.getDateOfConstruction().getYear());
            } else {
                attributes.put("dateOfDemolition", object.getDateOfDemolition().format(DateTimeFormatter.ISO_LOCAL_DATE));
            }
        }
        if (object.isSetHeights()) {
            for (HeightProperty property : object.getHeights()) {
                if (property.getObject() == null || ((Height)property.getObject()).getStatus() != HeightStatusValue.MEASURED || ((Height)property.getObject()).getValue() == null) continue;
                attributes.put("measuredHeight", ((Height)property.getObject()).getValue().getValue());
                break;
            }
        }
    }

    private LocalDate toLocalDate(String date) {
        try {
            if (this.localDateParser == null) {
                this.localDateParser = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalEnd().parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
            }
            return LocalDate.parse(date, this.localDateParser);
        }
        catch (Exception e) {
            return null;
        }
    }

    private LocalDate toLocalDate(int year) {
        try {
            return LocalDate.of(year, 1, 1);
        }
        catch (Exception e) {
            return null;
        }
    }
}

