/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.basictypes.CodeWithAuthority;
import org.xmlobjects.gml.model.deprecated.StringOrRef;
import org.xmlobjects.gml.model.feature.BoundingShape;
import org.xmlobjects.gml.model.geometry.DirectPosition;
import org.xmlobjects.gml.model.geometry.Envelope;

public abstract class AbstractFeatureAdapter<T extends AbstractFeature>
implements JsonObjectBuilder<T>,
JsonObjectSerializer<T> {
    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode extent;
        JsonNode name;
        JsonNode description;
        JsonNode identifier = attributes.consume("identifier");
        if (identifier.isTextual()) {
            object.setIdentifier(new CodeWithAuthority(identifier.asText(), (String)helper.getProperties().getOrDefault("org.citygml4j.cityjson.idCodeSpace", String.class, () -> "")));
        }
        if ((description = attributes.consume("description")).isTextual()) {
            object.setDescription(new StringOrRef(description.asText()));
        }
        if ((name = attributes.consume("name")).isTextual()) {
            object.getNames().add(new Code(name.asText()));
        }
        if ((extent = attributes.consume("geographicalExtent")).isArray() && extent.size() > 5) {
            Envelope envelope = new Envelope(new DirectPosition(new double[]{extent.get(0).asDouble(), extent.get(1).asDouble(), extent.get(2).asDouble()}), new DirectPosition(new double[]{extent.get(3).asDouble(), extent.get(4).asDouble(), extent.get(5).asDouble()}));
            envelope.setSrsDimension(Integer.valueOf(3));
            object.setBoundedBy(new BoundingShape(envelope));
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getIdentifier() != null && object.getIdentifier().getValue() != null) {
            attributes.put("identifier", object.getIdentifier().getValue());
        }
        if (object.getDescription() != null && object.getDescription().getValue() != null) {
            attributes.put("description", object.getDescription().getValue());
        }
        if (object.isSetNames()) {
            for (Code name : object.getNames()) {
                if (name.getValue() == null) continue;
                attributes.put("name", name.getValue());
                break;
            }
        }
        if (object.getBoundedBy() != null && object.getBoundedBy().isSetEnvelope()) {
            ArrayNode geographicalExtent = helper.getOrPutArray("geographicalExtent", node);
            object.getBoundedBy().getEnvelope().toCoordinateList3D().forEach(arg_0 -> ((ArrayNode)geographicalExtent).add(arg_0));
        }
        if (object.hasADEProperties()) {
            for (ADEProperty property : object.getADEProperties()) {
                helper.addADEProperty(property, node);
            }
        }
    }
}

