/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.common.TopLevelFeature;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.basictypes.CodeWithAuthority;
import org.xmlobjects.gml.model.deprecated.StringOrRef;

public abstract class AbstractSemanticObjectAdapter<T extends AbstractSpaceBoundary>
implements JsonObjectBuilder<T>,
JsonObjectSerializer<T> {
    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode name;
        JsonNode description;
        JsonNode identifier;
        JsonNode id = attributes.consume("id");
        if (id.isTextual()) {
            object.setId(id.asText());
        }
        if ((identifier = attributes.consume("identifier")).isTextual()) {
            object.setIdentifier(new CodeWithAuthority(identifier.asText(), (String)helper.getProperties().getOrDefault("org.citygml4j.cityjson.idCodeSpace", String.class, () -> "")));
        }
        if ((description = attributes.consume("description")).isTextual()) {
            object.setDescription(new StringOrRef(description.asText()));
        }
        if ((name = attributes.consume("name")).isTextual()) {
            object.getNames().add(new Code(name.asText()));
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        ObjectNode attributes;
        ObjectNode objectNode = attributes = object instanceof TopLevelFeature ? helper.getOrPutObject("attributes", node) : node;
        if (object.getId() != null) {
            attributes.put("id", object.getId());
        }
        if (object.getIdentifier() != null && object.getIdentifier().getValue() != null) {
            attributes.put("identifier", object.getIdentifier().getValue());
        }
        if (object.getDescription() != null && object.getDescription().getValue() != null) {
            attributes.put("description", object.getDescription().getValue());
        }
        if (object.isSetNames()) {
            for (Code name : object.getNames()) {
                if (name.getValue() == null) continue;
                attributes.put("name", name.getValue());
                break;
            }
        }
        if (object.isSetGenericAttributes()) {
            for (AbstractGenericAttributeProperty property : object.getGenericAttributes()) {
                JsonObjectSerializer<?> serializer;
                if (property.getObject() == null || "type".equals(((AbstractGenericAttribute)property.getObject()).getName()) || (serializer = helper.getContext().getSerializer(((AbstractGenericAttribute)property.getObject()).getClass(), helper.getVersion())) == null) continue;
                serializer.writeObject((AbstractGenericAttribute)property.getObject(), attributes, helper);
            }
        }
        if (object.hasADEProperties()) {
            for (AbstractGenericAttributeProperty property : object.getADEProperties()) {
                helper.addADEProperty(property, attributes);
            }
        }
    }
}

