/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceBuilder;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.cityjson.util.lod.LodMapper;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.AbstractAppearance;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractOccupiedSpace;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.core.ImplicitGeometry;
import org.citygml4j.core.model.core.ImplicitGeometryProperty;
import org.xmlobjects.gml.model.base.AbstractInlineOrByReferenceProperty;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurve;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiPoint;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSolid;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSolid;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSurface;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSolid;
import org.xmlobjects.gml.model.geometry.primitives.PointProperty;
import org.xmlobjects.gml.model.geometry.primitives.Shell;
import org.xmlobjects.gml.model.geometry.primitives.Solid;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;

public class SpaceGeometryBuilder {
    private final GeometryBuilder geometryBuilder;
    private final VerticesBuilder verticesBuilder;
    private final AppearanceBuilder appearanceBuilder;
    private final CityJSONBuilderHelper helper;

    SpaceGeometryBuilder(GeometryBuilder geometryBuilder, CityJSONBuilderHelper helper) {
        this.geometryBuilder = geometryBuilder;
        this.helper = helper;
        this.verticesBuilder = geometryBuilder.getVerticesBuilder();
        this.appearanceBuilder = geometryBuilder.getAppearanceBuilder();
    }

    void build(AbstractSpace object, JsonNode node, BoundaryFilter filter, Map<Integer, MultiSurfaceProvider> providers) {
        LodMapper lodMapper = this.geometryBuilder.getLodMapper();
        GeometryObject geometryObject = GeometryObject.newInstance();
        Map<Double, List<JsonNode>> geometriesByLod = this.geometryBuilder.groupGeometriesByLod(node);
        lodMapper.buildMapping(geometriesByLod.keySet());
        for (int lod = 0; lod < 4; ++lod) {
            List geometries = geometriesByLod.getOrDefault(lodMapper.getMappingFor(lod), Collections.emptyList());
            for (JsonNode element : geometries) {
                this.geometryBuilder.getGeometry((AbstractFeature)object, geometryObject, element, lod, filter, this.appearanceBuilder, this.verticesBuilder);
                if (geometryObject.isSetGeometry()) {
                    this.addGeometry(object, geometryObject.getGeometry(), lod, providers);
                    if (geometryObject.hasBoundaries()) {
                        for (AbstractSpaceBoundary boundary : geometryObject.getBoundaries()) {
                            object.getBoundaries().add(new AbstractSpaceBoundaryProperty(boundary));
                        }
                    }
                } else if (geometryObject.isSetImplicitGeometry() && object instanceof AbstractOccupiedSpace) {
                    AbstractOccupiedSpace space = (AbstractOccupiedSpace)object;
                    this.addImplicitGeometry(space, geometryObject.getImplicitGeometry(), lod);
                }
                geometryObject.reset(true);
            }
        }
        if (geometryObject.hasAppearances()) {
            for (Appearance appearance : geometryObject.getAppearances()) {
                object.getAppearances().add(new AbstractAppearanceProperty((AbstractAppearance)appearance));
            }
        }
    }

    private void addGeometry(AbstractSpace space, AbstractGeometry geometry, int lod, Map<Integer, MultiSurfaceProvider> providers) {
        MultiPoint multiPoint;
        if (geometry instanceof CompositeSurface) {
            CompositeSurface compositeSurface = (CompositeSurface)geometry;
            geometry = new MultiSurface(compositeSurface.getSurfaceMembers());
        } else if (geometry instanceof MultiSolid) {
            MultiSolid multiSolid = (MultiSolid)geometry;
            space.setSolid(lod, new SolidProperty((AbstractSolid)new CompositeSolid(multiSolid.getSolidMember())));
        }
        if (geometry instanceof Solid) {
            Solid solid = (Solid)geometry;
            space.setSolid(lod, new SolidProperty((AbstractSolid)solid));
        } else if (geometry instanceof MultiSurface) {
            MultiSurface multiSurface = (MultiSurface)geometry;
            if (this.helper.getTargetCityGMLVersion() != CityGMLVersion.v3_0 || multiSurface.getSurfaceMember().stream().anyMatch(AbstractInlineOrByReferenceProperty::isSetInlineObject)) {
                if (lod == 1) {
                    if (providers.containsKey(1)) {
                        providers.get(1).set(new MultiSurfaceProperty(multiSurface));
                    } else {
                        Solid solid = new Solid(new Shell(multiSurface.getSurfaceMember()));
                        space.setLod1Solid(new SolidProperty((AbstractSolid)solid));
                    }
                } else {
                    space.setMultiSurface(lod, new MultiSurfaceProperty((MultiSurface)geometry));
                }
            }
        } else if (geometry instanceof MultiCurve) {
            MultiCurve multiCurve = (MultiCurve)geometry;
            space.setMultiCurve(lod, new MultiCurveProperty(multiCurve));
        } else if (lod == 0 && geometry instanceof MultiPoint && (multiPoint = (MultiPoint)geometry).getPointMember().size() == 1) {
            space.setLod0Point((PointProperty)multiPoint.getPointMember().get(0));
        }
    }

    private void addImplicitGeometry(AbstractOccupiedSpace space, ImplicitGeometry implicitGeometry, int lod) {
        space.setImplicitRepresentation(lod, new ImplicitGeometryProperty(implicitGeometry));
    }
}

