/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceBuilder;
import org.citygml4j.cityjson.adapter.appearance.builder.TextureVerticesBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.core.model.appearance.AbstractTextureParameterization;
import org.citygml4j.core.model.appearance.AbstractTextureParameterizationProperty;
import org.citygml4j.core.model.appearance.GeometryReference;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.RingReference;
import org.citygml4j.core.model.appearance.TexCoordList;
import org.citygml4j.core.model.appearance.TextureAssociation;
import org.citygml4j.core.model.appearance.TextureAssociationProperty;
import org.citygml4j.core.model.appearance.TextureCoordinates;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRingProperty;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;

public class TextureBuilder {
    private final CityJSONBuilderHelper helper;

    TextureBuilder(CityJSONBuilderHelper helper) {
        this.helper = helper;
    }

    void build(JsonNode textures, List<SurfaceProperty> geometries, AppearanceBuilder appearanceBuilder, GeometryObject geometryObject) {
        TextureVerticesBuilder textureVerticesBuilder = appearanceBuilder.getTextureVerticesBuilder();
        Iterator iterator = textures.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            List<JsonNode> flatValues = this.flatValues(((JsonNode)entry.getValue()).path("values"));
            for (int index = 0; index < flatValues.size() && index < geometries.size(); ++index) {
                JsonNode ring;
                int textureIndex;
                JsonNode surface = flatValues.get(index);
                Polygon polygon = (Polygon)geometries.get(index).getObject();
                ParameterizedTexture texture = null;
                TexCoordList texCoordList = new TexCoordList();
                for (int ringNo = 0; ringNo < surface.size() && (textureIndex = (ring = surface.get(ringNo)).get(0).asInt(-1)) != -1 && (texture != null || (texture = appearanceBuilder.getOrCreateTexture(textureIndex, (String)entry.getKey(), geometryObject.getAppearanceInfo())) != null); ++ringNo) {
                    RingReference target;
                    List<Double> textureVertices = textureVerticesBuilder.getTextureVertices((ArrayNode)ring);
                    if (textureVertices.isEmpty() || (target = this.getRingReference(polygon, ringNo)) == null) continue;
                    texCoordList.getTextureCoordinates().add(new TextureCoordinates(textureVertices, target));
                }
                if (texture == null || !texCoordList.isSetTextureCoordinates()) continue;
                TextureAssociation textureAssociation = new TextureAssociation();
                textureAssociation.setTarget(new GeometryReference("#" + this.helper.getOrCreateId((AbstractGML)polygon)));
                textureAssociation.setTextureParameterization(new AbstractTextureParameterizationProperty((AbstractTextureParameterization)texCoordList));
                texture.getTextureParameterizations().add(new TextureAssociationProperty(textureAssociation));
            }
        }
    }

    private RingReference getRingReference(Polygon polygon, int ringNo) {
        LinearRing linearRing = null;
        if (ringNo == 0) {
            linearRing = (LinearRing)polygon.getExterior().getObject();
        } else if (polygon.isSetInterior() && --ringNo < polygon.getInterior().size()) {
            linearRing = (LinearRing)((AbstractRingProperty)polygon.getInterior().get(ringNo)).getObject();
        }
        return linearRing != null ? new RingReference("#" + this.helper.getOrCreateId((AbstractGML)linearRing)) : null;
    }

    private List<JsonNode> flatValues(JsonNode values) {
        ArrayList<JsonNode> flatValues = new ArrayList<JsonNode>();
        this.flatValues(values, flatValues);
        return flatValues;
    }

    private void flatValues(JsonNode texture, List<JsonNode> values) {
        if (texture.path(0).isArray() && texture.get(0).path(0).isArray() && texture.get(0).get(0).path(0).isValueNode()) {
            for (JsonNode element : texture) {
                values.add(element);
            }
        } else {
            for (JsonNode element : texture) {
                this.flatValues(element, values);
            }
        }
    }
}

