/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.citygml4j.cityjson.model.geometry.Transform;
import org.citygml4j.cityjson.model.geometry.Vertex;

public class VerticesBuilder {
    private final ArrayNode vertices;

    VerticesBuilder(ArrayNode vertices) {
        this.vertices = Objects.requireNonNull(vertices, "The vertices array must not be null.");
    }

    public List<Double> getVertices(ArrayNode indexes, boolean appendLastVertex) {
        ArrayList<Double> vertices = new ArrayList<Double>((appendLastVertex ? indexes.size() + 1 : indexes.size()) * 3);
        for (JsonNode index : indexes) {
            JsonNode vertex = this.vertices.get(index.asInt(-1));
            if (vertex == null || !vertex.isArray() || vertex.size() != 3) continue;
            vertices.add(vertex.get(0).asDouble(0.0));
            vertices.add(vertex.get(1).asDouble(0.0));
            vertices.add(vertex.get(2).asDouble(0.0));
        }
        if (appendLastVertex && !vertices.isEmpty()) {
            vertices.add((Double)vertices.get(0));
            vertices.add((Double)vertices.get(1));
            vertices.add((Double)vertices.get(2));
        }
        return vertices;
    }

    public void applyTransformation(ObjectNode transformNode) {
        JsonNode scale = transformNode.path("scale");
        JsonNode translate = transformNode.path("translate");
        if (!scale.isArray() || scale.size() < 3 || !translate.isArray() || translate.size() < 3) {
            return;
        }
        Transform transform = new Transform();
        transform.setScale(Vertex.of(scale.get(0).asDouble(0.0), scale.get(1).asDouble(0.0), scale.get(2).asDouble(0.0)));
        transform.setTranslate(Vertex.of(translate.get(0).asDouble(1.0), translate.get(1).asDouble(1.0), translate.get(2).asDouble(1.0)));
        for (int i = 0; i < this.vertices.size(); ++i) {
            JsonNode node = this.vertices.get(i);
            if (node == null || !node.isArray() || node.size() != 3) continue;
            ArrayNode vertex = (ArrayNode)node;
            vertex.set(0, vertex.get(0).asDouble(0.0) * transform.getScale().getX() + transform.getTranslate().getX());
            vertex.set(1, vertex.get(1).asDouble(0.0) * transform.getScale().getY() + transform.getTranslate().getY());
            vertex.set(2, vertex.get(2).asDouble(0.0) * transform.getScale().getZ() + transform.getTranslate().getZ());
        }
    }
}

