/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.basictypes.Sign;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.primitives.Curve;
import org.xmlobjects.gml.model.geometry.primitives.LineString;
import org.xmlobjects.gml.model.geometry.primitives.OrientableCurve;

public class CurveGeometryBuilder
extends GeometryBuilder {
    private final VerticesBuilder verticesBuilder;
    private final ArrayNode boundaries;
    private final boolean shouldBuild;
    private boolean reverse;

    CurveGeometryBuilder(EnumSet<GeometryType> allowedTypes, VerticesBuilder verticesBuilder, CityJSONSerializerHelper helper) {
        super(helper);
        this.verticesBuilder = verticesBuilder;
        this.boundaries = helper.createArray();
        this.shouldBuild = allowedTypes.contains((Object)GeometryType.MULTI_LINE_STRING);
    }

    ObjectNode build(AbstractGeometry geometry, Number lod) {
        if (!this.boundaries.isEmpty()) {
            ObjectNode node = this.helper.createObject();
            node.put("type", GeometryType.MULTI_LINE_STRING.toTypeName());
            this.setLod(lod, node);
            node.set("boundaries", (JsonNode)this.boundaries);
            return node;
        }
        return null;
    }

    @Override
    int size() {
        return this.boundaries.size();
    }

    public void visit(Curve curve) {
        this.addCurve((CoordinateListProvider)curve);
    }

    public void visit(LineString lineString) {
        this.addCurve((CoordinateListProvider)lineString);
    }

    public void visit(OrientableCurve orientableCurve) {
        if (orientableCurve.getOrientation() == Sign.MINUS) {
            this.reverse = !this.reverse;
            super.visit(orientableCurve);
            this.reverse = !this.reverse;
        } else {
            super.visit(orientableCurve);
        }
    }

    private void addCurve(CoordinateListProvider provider) {
        if (this.shouldBuild) {
            ArrayNode curve = this.boundaries.addArray();
            List<Integer> indexes = this.verticesBuilder.addVertices(provider.toCoordinateList3D(this.reverse));
            indexes.forEach(arg_0 -> ((ArrayNode)curve).add(arg_0));
        }
    }
}

