/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceInfo;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.model.appearance.X3DMaterial;
import org.citygml4j.core.util.reference.Referees;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;

public class MaterialBuilder {
    private final AppearanceSerializer appearanceSerializer;
    private final CityJSONSerializerHelper helper;
    private final Map<String, ObjectNode> materials = new HashMap<String, ObjectNode>();

    MaterialBuilder(AppearanceSerializer appearanceSerializer, CityJSONSerializerHelper helper) {
        this.appearanceSerializer = appearanceSerializer;
        this.helper = helper;
    }

    void addMaterials(AbstractGeometry geometry, boolean reverse, int index) {
        HashMap<String, AppearanceInfo> materialInfos = null;
        do {
            Referees referees;
            if (!geometry.hasLocalProperties() || (referees = (Referees)geometry.getLocalProperties().get(Referees.PROPERTY_NAME, Referees.class)) == null) continue;
            for (X3DMaterial material : referees.get(X3DMaterial.class)) {
                AppearanceInfo materialInfo;
                if (material.getIsFront() == reverse || (materialInfo = this.appearanceSerializer.getOrCreateMaterial(material)) == null) continue;
                if (materialInfos == null) {
                    materialInfos = new HashMap<String, AppearanceInfo>();
                }
                materialInfos.putIfAbsent(materialInfo.getTheme(), materialInfo);
            }
        } while ((geometry = (AbstractGeometry)geometry.getParent(AbstractGeometry.class)) != null);
        if (materialInfos != null) {
            for (AppearanceInfo materialInfo : materialInfos.values()) {
                X3DMaterial material;
                material = this.materials.get(materialInfo.getTheme());
                if (material == null) {
                    material = this.helper.createObject();
                    material.putArray("values");
                    this.materials.put(materialInfo.getTheme(), (ObjectNode)material);
                }
                ArrayNode values = (ArrayNode)material.get("values");
                this.appendNullValues(values, index);
                values.add(materialInfo.getIndex());
            }
        }
    }

    ObjectNode build(int index) {
        if (!this.materials.isEmpty()) {
            ObjectNode material = this.helper.createObject();
            for (Map.Entry<String, ObjectNode> entry : this.materials.entrySet()) {
                ObjectNode node = entry.getValue();
                ArrayNode values = (ArrayNode)node.get("values");
                if (values.size() < index) {
                    this.appendNullValues(values, index);
                } else if (this.collapseValues(values)) {
                    node.remove("values");
                    node.set("value", values.get(0));
                }
                material.set(entry.getKey(), (JsonNode)node);
            }
            return material;
        }
        return null;
    }

    private void appendNullValues(ArrayNode values, int index) {
        while (values.size() < index) {
            values.addNull();
        }
    }

    private boolean collapseValues(ArrayNode values) {
        int value = values.get(0).asInt(-1);
        if (value != -1) {
            for (int i = 1; i < values.size(); ++i) {
                if (values.get(i).asInt(-1) == value) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

