/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.compact.SimpleMultiPoint;
import org.xmlobjects.gml.model.geometry.primitives.Point;

public class PointGeometryBuilder
extends GeometryBuilder {
    private final VerticesBuilder verticesBuilder;
    private final ArrayNode boundaries;
    private final boolean shouldBuild;

    PointGeometryBuilder(EnumSet<GeometryType> allowedTypes, VerticesBuilder verticesBuilder, CityJSONSerializerHelper helper) {
        super(helper);
        this.verticesBuilder = verticesBuilder;
        this.boundaries = helper.createArray();
        this.shouldBuild = allowedTypes.contains((Object)GeometryType.MULTI_POINT);
    }

    ObjectNode build(AbstractGeometry geometry, Number lod) {
        if (!this.boundaries.isEmpty()) {
            ObjectNode node = this.helper.createObject();
            node.put("type", GeometryType.MULTI_POINT.toTypeName());
            this.setLod(lod, node);
            node.set("boundaries", (JsonNode)this.boundaries);
            return node;
        }
        return null;
    }

    @Override
    int size() {
        return this.boundaries.size();
    }

    public void visit(Point point) {
        this.addPoint((CoordinateListProvider)point);
    }

    public void visit(SimpleMultiPoint simpleMultiPoint) {
        if (simpleMultiPoint.getPosList() != null) {
            this.addPoint((CoordinateListProvider)simpleMultiPoint.getPosList());
        }
    }

    private void addPoint(CoordinateListProvider provider) {
        if (this.shouldBuild) {
            this.verticesBuilder.addVertices(provider.toCoordinateList3D()).forEach(arg_0 -> ((ArrayNode)this.boundaries).add(arg_0));
        }
    }
}

