/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.MaterialBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.SemanticsBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.TextureBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.basictypes.Sign;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.compact.AbstractSimplePolygon;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRingProperty;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.model.geometry.primitives.OrientableSurface;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.PolygonPatch;

public class SurfaceGeometryBuilder
extends GeometryBuilder {
    private final EnumSet<GeometryType> allowedTypes;
    private final VerticesBuilder verticesBuilder;
    private final SemanticsBuilder semanticsBuilder;
    private final MaterialBuilder materialBuilder;
    private final TextureBuilder textureBuilder;
    private final ArrayNode boundaries;
    private final boolean shouldBuild;
    private boolean reverse;
    private int index;

    SurfaceGeometryBuilder(EnumSet<GeometryType> allowedTypes, AppearanceSerializer appearanceSerializer, VerticesBuilder verticesBuilder, CityJSONSerializerHelper helper) {
        super(helper);
        this.allowedTypes = allowedTypes;
        this.verticesBuilder = verticesBuilder;
        this.semanticsBuilder = new SemanticsBuilder(helper);
        this.materialBuilder = new MaterialBuilder(appearanceSerializer, helper);
        this.textureBuilder = new TextureBuilder(appearanceSerializer, helper);
        this.boundaries = helper.createArray();
        this.shouldBuild = GeometryType.SURFACE_TYPES.stream().anyMatch(allowedTypes::contains);
    }

    ObjectNode build(AbstractGeometry geometry, Number lod) {
        if (!this.boundaries.isEmpty()) {
            ObjectNode texture;
            ObjectNode material;
            ObjectNode node = this.helper.createObject();
            node.put("type", geometry instanceof AbstractSurface && this.allowedTypes.contains((Object)GeometryType.COMPOSITE_SURFACE) ? GeometryType.COMPOSITE_SURFACE.toTypeName() : GeometryType.MULTI_SURFACE.toTypeName());
            this.setLod(lod, node);
            node.set("boundaries", (JsonNode)this.boundaries);
            ObjectNode semantics = this.semanticsBuilder.build(this.index);
            if (semantics != null) {
                node.set("semantics", (JsonNode)semantics);
            }
            if ((material = this.materialBuilder.build(this.index)) != null) {
                node.set("material", (JsonNode)material);
            }
            if ((texture = this.textureBuilder.build(this.index)) != null) {
                node.set("texture", (JsonNode)texture);
            }
            return node;
        }
        return null;
    }

    @Override
    int size() {
        return this.boundaries.size();
    }

    public void visit(Polygon polygon) {
        List<List<Integer>> indexes = this.createVertices(polygon);
        if (indexes != null) {
            this.textureBuilder.addTextures(polygon, this.reverse, this.index);
            this.addSurface((AbstractGeometry)polygon, indexes);
        }
    }

    public void visit(AbstractSimplePolygon simplePolygon) {
        List<List<Integer>> indexes = this.createVertices(simplePolygon);
        if (indexes != null) {
            this.textureBuilder.addTextures(simplePolygon, this.reverse, this.index);
            this.addSurface((AbstractGeometry)simplePolygon, indexes);
        }
    }

    public void visit(PolygonPatch polygonPatch) {
        List<List<Integer>> indexes = this.createVertices(polygonPatch);
        if (indexes != null) {
            this.textureBuilder.addTextures(polygonPatch, this.reverse, this.index);
            this.addSurface((AbstractGeometry)polygonPatch.getParent(AbstractGeometry.class), indexes);
        }
    }

    public void visit(LinearRing linearRing) {
        List<Integer> indexes = this.createVertices((CoordinateListProvider)linearRing);
        if (indexes != null) {
            this.textureBuilder.addTextures(linearRing, this.reverse, this.index);
            this.addSurface((AbstractGeometry)linearRing, List.of(indexes));
        }
    }

    public void visit(OrientableSurface orientableSurface) {
        if (orientableSurface.getOrientation() == Sign.MINUS) {
            this.reverse = !this.reverse;
            super.visit(orientableSurface);
            this.reverse = !this.reverse;
        } else {
            super.visit(orientableSurface);
        }
    }

    public void visit(MultiSurface multiSurface) {
        if (this.allowedTypes.contains((Object)GeometryType.MULTI_SURFACE)) {
            super.visit(multiSurface);
        }
    }

    private void addSurface(AbstractGeometry geometry, List<List<Integer>> indexes) {
        ArrayNode surface = this.boundaries.addArray();
        for (List<Integer> element : indexes) {
            ArrayNode ring = surface.addArray();
            element.forEach(arg_0 -> ((ArrayNode)ring).add(arg_0));
        }
        this.semanticsBuilder.addSemantics(geometry, this.index);
        this.materialBuilder.addMaterials(geometry, this.reverse, this.index);
        ++this.index;
    }

    private List<Integer> createVertices(CoordinateListProvider provider) {
        if (this.shouldBuild) {
            List vertices = provider.toCoordinateList3D(this.reverse);
            int size = vertices.size();
            if (size > 5 && ((Double)vertices.get(0)).equals(vertices.get(size - 3)) && ((Double)vertices.get(1)).equals(vertices.get(size - 2)) && ((Double)vertices.get(2)).equals(vertices.get(size - 1))) {
                vertices = vertices.subList(0, vertices.size() - 3);
            }
            return this.verticesBuilder.addVertices(vertices);
        }
        return null;
    }

    private List<List<Integer>> createVertices(Polygon polygon) {
        return this.createVertices(polygon.getExterior(), polygon.isSetInterior() ? polygon.getInterior() : null);
    }

    private List<List<Integer>> createVertices(PolygonPatch polygonPatch) {
        return this.createVertices(polygonPatch.getExterior(), polygonPatch.isSetInterior() ? polygonPatch.getInterior() : null);
    }

    private List<List<Integer>> createVertices(AbstractSimplePolygon simplePolygon) {
        List<Integer> indexes = this.createVertices((CoordinateListProvider)simplePolygon.getControlPoints());
        return indexes != null ? List.of(indexes) : null;
    }

    private List<List<Integer>> createVertices(AbstractRingProperty exterior, List<AbstractRingProperty> interior) {
        List<Integer> element;
        ArrayList<List<Integer>> indexes = null;
        if (exterior != null && exterior.getObject() != null && (element = this.createVertices((CoordinateListProvider)exterior.getObject())) != null) {
            indexes = new ArrayList<List<Integer>>();
            indexes.add(element);
            if (interior != null) {
                for (AbstractRingProperty property : interior) {
                    if (property.getObject() == null || (element = this.createVertices((CoordinateListProvider)property.getObject())) == null) continue;
                    indexes.add(element);
                }
            }
        }
        return indexes;
    }
}

