/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.transportation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.core.AbstractUnoccupiedSpaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.serializer.SpaceGeometryBuilder;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.deprecated.transportation.DeprecatedPropertiesOfAbstractTransportationSpace;
import org.citygml4j.core.model.transportation.AbstractTransportationSpace;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficArea;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficSpace;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficSpaceProperty;
import org.citygml4j.core.model.transportation.GranularityValue;
import org.citygml4j.core.model.transportation.Hole;
import org.citygml4j.core.model.transportation.HoleProperty;
import org.citygml4j.core.model.transportation.HoleSurface;
import org.citygml4j.core.model.transportation.Marking;
import org.citygml4j.core.model.transportation.MarkingProperty;
import org.citygml4j.core.model.transportation.TrafficArea;
import org.citygml4j.core.model.transportation.TrafficDirectionValue;
import org.citygml4j.core.model.transportation.TrafficSpace;
import org.citygml4j.core.model.transportation.TrafficSpaceProperty;
import org.xmlobjects.gml.model.feature.AbstractFeature;
import org.xmlobjects.gml.model.feature.FeatureProperty;
import org.xmlobjects.util.copy.CopyBuilder;

public abstract class AbstractTransportationSpaceAdapter<T extends AbstractTransportationSpace>
extends AbstractUnoccupiedSpaceAdapter<T> {
    private CopyBuilder copyBuilder;
    private final EnumSet<GeometryType> allowedTypes = EnumSet.of(GeometryType.MULTI_LINE_STRING, GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE);

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode geometries = helper.consumeProperty("geometry", node);
        super.buildObject(object, attributes, node, parent, helper);
        JsonNode trafficDirection = attributes.consume("trafficDirection");
        if (trafficDirection.isTextual()) {
            object.setTrafficDirection(TrafficDirectionValue.fromValue((String)trafficDirection.asText()));
        }
        helper.addGeometries((AbstractSpace)object, geometries, type -> object.isValidBoundary(type) || TrafficArea.class.isAssignableFrom(type) || AuxiliaryTrafficArea.class.isAssignableFrom(type) || helper.getTargetCityGMLVersion() == CityGMLVersion.v3_0 && (HoleSurface.class.isAssignableFrom(type) || Marking.class.isAssignableFrom(type)));
        if (object.isSetBoundaries()) {
            Iterator iterator = object.getBoundaries().iterator();
            while (iterator.hasNext()) {
                AbstractSpaceBoundaryProperty property = (AbstractSpaceBoundaryProperty)iterator.next();
                AbstractSpaceBoundary boundary = (AbstractSpaceBoundary)property.getObject();
                if (boundary instanceof TrafficArea) {
                    TrafficSpace trafficSpace = new TrafficSpace(GranularityValue.WAY);
                    trafficSpace.addBoundary(property);
                    object.getTrafficSpaces().add(new TrafficSpaceProperty(trafficSpace));
                } else if (boundary instanceof AuxiliaryTrafficArea) {
                    AuxiliaryTrafficSpace auxiliaryTrafficSpace = new AuxiliaryTrafficSpace(GranularityValue.WAY);
                    auxiliaryTrafficSpace.addBoundary(property);
                    object.getAuxiliaryTrafficSpaces().add(new AuxiliaryTrafficSpaceProperty(auxiliaryTrafficSpace));
                } else if (boundary instanceof HoleSurface) {
                    Hole hole = new Hole();
                    hole.addBoundary(property);
                    object.getHoles().add(new HoleProperty(hole));
                } else {
                    if (!(boundary instanceof Marking)) continue;
                    Marking marking = (Marking)boundary;
                    object.getMarkings().add(new MarkingProperty(marking));
                }
                iterator.remove();
            }
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        if (object.isSetTrafficSpaces()) {
            object.getTrafficSpaces().forEach(property -> this.addBoundaries((FeatureProperty<AbstractSpace>)property, object));
        }
        if (object.isSetAuxiliaryTrafficSpaces()) {
            object.getAuxiliaryTrafficSpaces().forEach(property -> this.addBoundaries((FeatureProperty<AbstractSpace>)property, object));
        }
        if (object.isSetHoles()) {
            object.getHoles().forEach(property -> this.addBoundaries((FeatureProperty<AbstractSpace>)property, object));
        }
        if (object.isSetMarkings()) {
            object.getMarkings().forEach(property -> this.addBoundary((FeatureProperty<AbstractSpaceBoundary>)property, object));
        }
        SpaceGeometryBuilder.newInstance().addUnreferencedBoundaryGeometries((AbstractSpace)object);
        super.writeObject(object, node, helper);
        if (object.isSetBoundaries()) {
            object.getBoundaries().removeIf(boundary -> boundary.hasLocalProperties() && boundary.getLocalProperties().contains("org.citygml4j.tempObject"));
        }
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        if (object.getTrafficDirection() != null) {
            attributes.put("trafficDirection", object.getTrafficDirection().toValue());
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes;
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(T object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAbstractTransportationSpace properties = object.getDeprecatedProperties();
            return Map.of(1, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractTransportationSpace)properties).getLod1MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractTransportationSpace)properties).setLod1MultiSurface(arg_0)), 4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractTransportationSpace)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractTransportationSpace)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }

    private void addBoundary(FeatureProperty<? extends AbstractSpaceBoundary> property, T object) {
        if (property.getObject() != null) {
            AbstractSpaceBoundaryProperty dummy = new AbstractSpaceBoundaryProperty();
            dummy.setReferencedObject((AbstractFeature)((AbstractSpaceBoundary)property.getObject()));
            dummy.getLocalProperties().set("org.citygml4j.tempObject", (Object)true);
            object.getBoundaries().add(dummy);
        }
    }

    private void addBoundaries(FeatureProperty<? extends AbstractSpace> property, T object) {
        if (property.getObject() != null && ((AbstractSpace)property.getObject()).isSetBoundaries()) {
            ((AbstractSpace)property.getObject()).getBoundaries().forEach(boundary -> this.addBoundary((FeatureProperty<AbstractSpaceBoundary>)boundary, object));
        }
    }

    <S extends AbstractTransportationSpace, D extends AbstractTransportationSpace> D shallowCopy(S src, D dest) {
        if (this.copyBuilder == null) {
            this.copyBuilder = new CopyBuilder();
        }
        return (D)((AbstractTransportationSpace)this.copyBuilder.shallowCopy(src, dest, AbstractTransportationSpace.class));
    }
}

