/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.vegetation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.adapter.vegetation.AbstractVegetationObjectAdapter;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.vegetation.SolitaryVegetationObject;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.measures.Length;

@CityJSONElements(value={@CityJSONElement(name="SolitaryVegetationObject", schema="CityJSON-Core", version=CityJSONVersion.v2_0), @CityJSONElement(name="SolitaryVegetationObject", schema="CityJSON-Core", version=CityJSONVersion.v1_1), @CityJSONElement(name="SolitaryVegetationObject", schema="CityJSON-Core", version=CityJSONVersion.v1_0)})
public class SolitaryVegetationObjectAdapter
extends AbstractVegetationObjectAdapter<SolitaryVegetationObject> {
    @Override
    public SolitaryVegetationObject createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new SolitaryVegetationObject();
    }

    @Override
    public void buildObject(SolitaryVegetationObject object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode maxRootBallDepth;
        JsonNode rootBallDiameter;
        JsonNode crownDiameter;
        JsonNode trunkDiameter;
        JsonNode height;
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        JsonNode species = attributes.consume("species");
        if (species.isTextual()) {
            object.setSpecies(new Code(species.asText()));
        }
        if ((height = attributes.consume("height")).isNumber()) {
            object.setHeight(new Length(Double.valueOf(height.asDouble()), "m"));
        }
        if ((trunkDiameter = attributes.consume("trunkDiameter")).isNumber()) {
            object.setTrunkDiameter(new Length(Double.valueOf(trunkDiameter.asDouble()), "m"));
        }
        if ((crownDiameter = attributes.consume("crownDiameter")).isNumber()) {
            object.setCrownDiameter(new Length(Double.valueOf(crownDiameter.asDouble()), "m"));
        }
        if ((rootBallDiameter = attributes.consume("rootBallDiameter")).isNumber()) {
            object.setRootBallDiameter(new Length(Double.valueOf(rootBallDiameter.asDouble()), "m"));
        }
        if ((maxRootBallDepth = attributes.consume("maxRootBallDepth")).isNumber()) {
            object.setMaxRootBallDepth(new Length(Double.valueOf(maxRootBallDepth.asDouble()), "m"));
        }
    }

    @Override
    public String createType(SolitaryVegetationObject object, CityJSONVersion version) throws CityJSONSerializeException {
        return "SolitaryVegetationObject";
    }

    @Override
    public void writeObject(SolitaryVegetationObject object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.getSpecies() != null && object.getSpecies().getValue() != null) {
            attributes.put("species", object.getSpecies().getValue());
        }
        if (object.getHeight() != null && object.getHeight().getValue() != null) {
            attributes.put("height", object.getHeight().getValue());
        }
        if (object.getTrunkDiameter() != null && object.getTrunkDiameter().getValue() != null) {
            attributes.put("trunkDiameter", object.getTrunkDiameter().getValue());
        }
        if (object.getCrownDiameter() != null && object.getCrownDiameter().getValue() != null) {
            attributes.put("crownDiameter", object.getCrownDiameter().getValue());
        }
        if (object.getRootBallDiameter() != null && object.getRootBallDiameter().getValue() != null) {
            attributes.put("rootBallDiameter", object.getRootBallDiameter().getValue());
        }
        if (object.getMaxRootBallDepth() != null && object.getMaxRootBallDepth().getValue() != null) {
            attributes.put("maxRootBallDepth", object.getMaxRootBallDepth().getValue());
        }
    }
}

