/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.model.metadata;

import java.util.regex.Matcher;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.util.CityJSONPatterns;

public class ReferenceSystem {
    private final String authority;
    private final String version;
    private final int code;

    public ReferenceSystem(String authority, String version, int code) {
        this.authority = authority != null && !authority.isEmpty() ? authority : "EPSG";
        this.version = version != null && !version.isEmpty() ? version : "0";
        this.code = code;
    }

    public ReferenceSystem(String authority, int code) {
        this(authority, null, code);
    }

    public ReferenceSystem(int code) {
        this(null, code);
    }

    public static ReferenceSystem parse(String referenceSystem) {
        if (referenceSystem != null) {
            Matcher matcher = CityJSONPatterns.CRS_URL.matcher(referenceSystem);
            if (matcher.matches()) {
                return new ReferenceSystem(matcher.group(1), matcher.group(2), Integer.parseInt(matcher.group(3)));
            }
            if (matcher.usePattern(CityJSONPatterns.CRS_URN).matches()) {
                return new ReferenceSystem(matcher.group(1), matcher.group(2), Integer.parseInt(matcher.group(3)));
            }
            if (matcher.usePattern(CityJSONPatterns.CRS_SHORT).matches()) {
                return new ReferenceSystem(matcher.group(1), Integer.parseInt(matcher.group(2)));
            }
        }
        return null;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getVersion() {
        return this.version;
    }

    public int getCode() {
        return this.code;
    }

    public String toURL() {
        return "http://www.opengis.net/def/crs/" + this.authority + "/" + this.version + "/" + this.code;
    }

    public String toURN() {
        return "urn:ogc:def:crs:" + this.authority + ":" + (!this.version.equals("0") ? this.version : "") + ":" + this.code;
    }

    public String toURI(CityJSONVersion version) {
        return version == CityJSONVersion.v1_0 ? "urn:ogc:def:crs:EPSG::" + this.code : this.toURL();
    }
}

