/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.reader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.adapter.extension.ExtensionInfo;
import org.citygml4j.cityjson.adapter.extension.ExtensionInfoAdapter;
import org.citygml4j.cityjson.adapter.metadata.MetadataAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.model.metadata.Metadata;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONInputFilter;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.util.lod.LodMapper;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.core.ADEOfCityModel;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.gml.util.reference.ReferenceResolver;
import org.xmlobjects.util.Properties;

public abstract class CityJSONReader
implements AutoCloseable {
    final JsonParser reader;
    final ObjectMapper objectMapper;
    final CityJSONContext context;
    final ObjectNode globalScope;
    final Deque<String> topLevelObjects = new ArrayDeque<String>();
    CityJSONInputFilter filter;
    Metadata metadata;
    Map<String, ExtensionInfo> extensions;
    Map<String, ADEOfCityModel> extraRootProperties;
    CityGMLVersion targetCityGMLVersion;
    boolean mapUnsupportedTypesToGenerics = true;
    boolean transformTemplateGeometries;
    boolean assignAppearancesToImplicitGeometries;
    ReferenceResolver resolver;
    LodMapper lodMapper;
    IdCreator idCreator;
    Properties properties;

    CityJSONReader(JsonParser reader, ObjectMapper mapper, CityJSONContext context) {
        this.reader = reader;
        this.objectMapper = mapper;
        this.context = context;
        this.globalScope = mapper.createObjectNode();
    }

    public abstract boolean hasNext() throws CityJSONReadException;

    public abstract AbstractFeature next() throws CityJSONReadException;

    public Metadata getMetadata() throws CityJSONReadException {
        return this.hasNext() ? this.metadata : null;
    }

    public boolean hasExtensions() throws CityJSONReadException {
        return this.hasNext() && this.extensions != null && !this.extensions.isEmpty();
    }

    public Collection<ExtensionInfo> getExtensions() throws CityJSONReadException {
        return this.hasExtensions() ? this.extensions.values() : Collections.emptyList();
    }

    public ExtensionInfo getExtension(String name) throws CityJSONReadException {
        return this.hasExtensions() ? this.extensions.get(name) : null;
    }

    public boolean hasExtraRootProperties() throws CityJSONReadException {
        return this.hasNext() && this.extraRootProperties != null && !this.extraRootProperties.isEmpty();
    }

    public Collection<ADEOfCityModel> getExtraRootProperties() throws CityJSONReadException {
        return this.hasExtraRootProperties() ? this.extraRootProperties.values() : Collections.emptyList();
    }

    public <T extends ADEOfCityModel> T getExtraRootProperty(String propertyName, Class<T> type) throws CityJSONReadException {
        ADEOfCityModel property;
        if (this.hasExtraRootProperties() && type.isInstance(property = this.extraRootProperties.get(propertyName))) {
            return (T)((ADEOfCityModel)type.cast(property));
        }
        return null;
    }

    @Override
    public void close() throws CityJSONReadException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
        finally {
            this.globalScope.removeAll();
            this.metadata = null;
            if (this.extensions != null) {
                this.extensions.clear();
            }
            if (this.extraRootProperties != null) {
                this.extraRootProperties.clear();
            }
        }
    }

    void buildAsTopLevelObject(String identifier) {
        if (identifier != null && !identifier.isEmpty()) {
            this.topLevelObjects.push(identifier);
        }
    }

    CityJSONBuilderHelper createHelper(ObjectNode content, CityJSONBuilderHelper previous) throws CityJSONBuildException, CityJSONReadException {
        CityJSONBuilderHelper helper = CityJSONBuilderHelper.buildFor(this, content, this.globalScope, this.objectMapper, this.context);
        helper.setTargetCityGMLVersion(this.targetCityGMLVersion);
        helper.setMapUnsupportedTypesToGenerics(this.mapUnsupportedTypesToGenerics);
        helper.setTransformTemplateGeometries(this.transformTemplateGeometries);
        helper.setAssignAppearancesToImplicitGeometries(this.assignAppearancesToImplicitGeometries);
        helper.setProperties(this.properties);
        if (previous != null) {
            helper.setTemplateInfo(previous.getTemplateInfo());
        }
        if (this.idCreator != null) {
            helper.setIdCreator(this.idCreator);
        }
        if (this.lodMapper != null) {
            helper.setLodMapper(this.lodMapper);
        }
        if (helper.getType() == CityJSONType.CITYJSON) {
            this.createMetadata(content, helper);
            this.createExtensions(content, helper);
            this.createExtraRootProperties(content, helper);
        }
        helper.setMetadata(this.metadata);
        helper.setExtensions(this.extensions);
        helper.setExtraRootProperties(this.extraRootProperties);
        return helper;
    }

    private void createMetadata(ObjectNode content, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        this.metadata = (Metadata)helper.getObjectUsingBuilder(content.get("metadata"), MetadataAdapter.class);
        content.remove("metadata");
    }

    private void createExtensions(ObjectNode content, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode node = content.path("extensions");
        if (node.isObject()) {
            this.extensions = new HashMap<String, ExtensionInfo>();
            Iterator iterator = node.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String name = (String)entry.getKey();
                ExtensionInfo extensionInfo = (ExtensionInfo)helper.getObjectUsingBuilder((JsonNode)entry.getValue(), ExtensionInfoAdapter.class);
                if (extensionInfo == null) continue;
                extensionInfo.setName(name);
                this.extensions.put(name, extensionInfo);
            }
        }
    }

    private void createExtraRootProperties(ObjectNode content, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        Iterator iterator = content.fields();
        block14: while (iterator.hasNext()) {
            String name;
            Map.Entry entry = (Map.Entry)iterator.next();
            switch (name = (String)entry.getKey()) {
                case "type": 
                case "version": 
                case "transform": 
                case "CityObjects": 
                case "vertices": 
                case "metadata": 
                case "extensions": 
                case "appearance": 
                case "geometry-templates": {
                    continue block14;
                }
            }
            ADEOfCityModel property = helper.getObject(name, (JsonNode)entry.getValue(), ADEOfCityModel.class);
            if (property != null) {
                if (this.extraRootProperties == null) {
                    this.extraRootProperties = new HashMap<String, ADEOfCityModel>();
                }
                this.extraRootProperties.put(name, property);
            }
            iterator.remove();
        }
    }

    static class TopLevelIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        private final CityJSONBuilderHelper helper;
        private final CityJSONInputFilter filter;
        private Map.Entry<String, JsonNode> next;

        private TopLevelIterator(CityJSONBuilderHelper helper, CityJSONInputFilter filter) {
            this.helper = helper;
            this.filter = filter;
        }

        static TopLevelIterator of(CityJSONBuilderHelper helper, CityJSONInputFilter filter) {
            return new TopLevelIterator(helper, filter);
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                Iterator iterator = this.helper.getCityObjects().fields();
                while (iterator.hasNext()) {
                    JsonNode parents;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    JsonNode object = (JsonNode)entry.getValue();
                    if (!object.isObject() || !(parents = object.path("parents")).isEmpty()) continue;
                    iterator.remove();
                    String type = object.path("type").asText();
                    if (this.filter != null && !this.filter.accept(type)) continue;
                    this.next = entry;
                    break;
                }
            }
            return this.next != null;
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            if (this.hasNext()) {
                try {
                    Map.Entry<String, JsonNode> entry = this.next;
                    return entry;
                }
                finally {
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }
    }
}

