/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.util.lod;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.citygml4j.cityjson.util.lod.LodMapper;

public class DefaultLodMapper
implements LodMapper {
    private final Map<Integer, Double> mappings = new HashMap<Integer, Double>();
    private Strategy strategy = Strategy.MAXIMUM_LOD;

    public DefaultLodMapper withMappingStrategy(Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Override
    public void buildMapping(Set<Double> lods) {
        this.mappings.clear();
        lods.stream().sorted(this.strategy == Strategy.MAXIMUM_LOD ? Comparator.naturalOrder() : Comparator.reverseOrder()).forEach(lod -> this.mappings.put(lod.intValue(), (Double)lod));
    }

    @Override
    public double getMappingFor(int lod) {
        return this.mappings.getOrDefault(lod, Double.valueOf(lod));
    }

    public static enum Strategy {
        MAXIMUM_LOD,
        MINIMUM_LOD;

    }
}

