/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.core.AbstractSpaceAdapter;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometrySerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.SpaceGeometryBuilder;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.core.ExtendedSpaceGeometry;
import org.citygml4j.cityjson.model.generics.GenericAttributeTypes;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.model.geometry.Vertex;
import org.citygml4j.cityjson.model.metadata.Metadata;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.util.ArrayBuffer;
import org.citygml4j.cityjson.writer.AbstractCityJSONWriter;
import org.citygml4j.cityjson.writer.CityJSONFeatureWriter;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.common.GeometryInfo;
import org.citygml4j.core.model.core.ADEOfAbstractSpace;
import org.citygml4j.core.model.core.ADEOfCityModel;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractThematicSurface;
import org.citygml4j.core.model.core.ImplicitGeometry;
import org.citygml4j.core.model.core.ImplicitGeometryProperty;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.visitor.ObjectVisitor;
import org.citygml4j.core.visitor.ObjectWalker;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.feature.FeatureProperty;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.util.id.DefaultIdCreator;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.util.Properties;

public class CityJSONSerializerHelper {
    public static final String SEMANTIC_SURFACE = "org.citygml4j.cityjson.semanticSurface";
    public static final String TEMPORARY_OBJECT = "org.citygml4j.tempObject";
    private final AbstractCityJSONWriter<?> writer;
    private final CityJSONType type;
    private final CityJSONVersion version;
    private final ObjectMapper objectMapper;
    private final CityJSONContext context;
    private final GeometrySerializer geometrySerializer;
    private final AppearanceSerializer appearanceSerializer;
    private final Map<Class<?>, JsonObjectSerializer<?>> serializerCache = new IdentityHashMap();
    private IdCreator idCreator = DefaultIdCreator.getInstance();
    private boolean applyTransformation;
    private boolean computeCityModelExtent = true;
    private boolean writeGenericAttributeTypes;
    private Map<String, ObjectNode> extensions;
    private Metadata metadata;
    private ObjectNode extraRootProperties;
    private Properties properties;

    CityJSONSerializerHelper(AbstractCityJSONWriter<?> writer, CityJSONVersion version, ObjectMapper objectMapper, CityJSONContext context) {
        this.writer = writer;
        this.version = version;
        this.objectMapper = objectMapper;
        this.context = context;
        this.type = writer instanceof CityJSONFeatureWriter ? CityJSONType.CITYJSON_FEATURE : CityJSONType.CITYJSON;
        this.appearanceSerializer = new AppearanceSerializer(this);
        this.geometrySerializer = new GeometrySerializer(this.appearanceSerializer, this);
    }

    public CityJSONType getType() {
        return this.type;
    }

    public CityJSONVersion getVersion() {
        return this.version;
    }

    public CityJSONContext getContext() {
        return this.context;
    }

    GeometrySerializer getGeometrySerializer() {
        return this.geometrySerializer;
    }

    AppearanceSerializer getAppearanceSerializer() {
        return this.appearanceSerializer;
    }

    public IdCreator getIdCreator() {
        return this.idCreator;
    }

    void setIdCreator(IdCreator idCreator) {
        this.idCreator = Objects.requireNonNull(idCreator, "The ID creator must not be null.");
    }

    boolean isApplyTransformation() {
        return this.applyTransformation;
    }

    void setApplyTransformation(boolean applyTransformation) {
        this.applyTransformation = applyTransformation;
    }

    boolean isComputeCityModelExtent() {
        return this.computeCityModelExtent;
    }

    void setComputeCityModelExtent(boolean computeCityModelExtent) {
        this.computeCityModelExtent = computeCityModelExtent;
    }

    public boolean isWriteGenericAttributeTypes() {
        return this.writeGenericAttributeTypes;
    }

    void setWriteGenericAttributeTypes(boolean writeGenericAttributeTypes) {
        this.writeGenericAttributeTypes = writeGenericAttributeTypes;
        if (writeGenericAttributeTypes) {
            this.properties.set(GenericAttributeTypes.class.getName(), (Object)new GenericAttributeTypes());
        } else {
            this.properties.remove(GenericAttributeTypes.class.getName());
        }
    }

    boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public boolean isSetExternalExtension(String name) {
        return this.extensions != null && this.extensions.containsKey(name);
    }

    Map<String, ObjectNode> getExternalExtensions() {
        return this.extensions != null ? this.extensions : Collections.emptyMap();
    }

    public void addExternalExtension(String name, String url, String version) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, ObjectNode>();
        }
        ObjectNode node = this.createObject();
        node.put("url", url);
        node.put("version", version);
        this.extensions.put(name, node);
    }

    boolean hasMetadata() {
        return this.metadata != null;
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    void setMetadata(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "The metadata must not be null.");
    }

    boolean hasExtraRootProperties() {
        return this.extraRootProperties != null && !this.extraRootProperties.isEmpty();
    }

    ObjectNode getExtraRootProperties() {
        if (this.extraRootProperties == null) {
            this.extraRootProperties = this.createObject();
        }
        return this.extraRootProperties;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getOrCreateId(AbstractGML object) {
        if (object.getId() == null) {
            object.setId(this.idCreator.createId());
        }
        return object.getId();
    }

    public ObjectNode createObject() {
        return this.objectMapper.createObjectNode();
    }

    public ObjectNode getOrPutObject(String propertyName, ObjectNode node) {
        JsonNode candidate = node.path(propertyName);
        return candidate.isObject() ? (ObjectNode)candidate : node.putObject(propertyName);
    }

    public ArrayNode createArray() {
        return this.objectMapper.createArrayNode();
    }

    public ArrayNode getOrPutArray(String propertyName, ObjectNode node) {
        JsonNode candidate = node.path(propertyName);
        return candidate.isArray() ? (ArrayNode)candidate : node.putArray(propertyName);
    }

    public void removeIfEmpty(String propertyName, ObjectNode node) {
        if (node.path(propertyName).isEmpty()) {
            node.remove(propertyName);
        }
    }

    public void addGeometry(GeometryProperty<?> property, Number lod, ObjectNode object) {
        this.addGeometry(property, lod, object, EnumSet.allOf(GeometryType.class));
    }

    public void addGeometry(AbstractGeometry geometry, Number lod, ObjectNode object) {
        this.addGeometry(geometry, lod, object, EnumSet.allOf(GeometryType.class));
    }

    public void addGeometry(GeometryProperty<?> property, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        if (property != null) {
            this.addGeometry(property.getObject(), lod, object, allowedTypes);
        }
    }

    public void addGeometry(AbstractGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        this.geometrySerializer.addGeometry(geometry, lod, object, allowedTypes);
    }

    public ObjectNode getGeometry(GeometryProperty<?> property, Number lod) {
        return this.getGeometry(property, lod, EnumSet.allOf(GeometryType.class));
    }

    public ObjectNode getGeometry(AbstractGeometry geometry, Number lod) {
        return this.getGeometry(geometry, lod, EnumSet.allOf(GeometryType.class));
    }

    public ObjectNode getGeometry(GeometryProperty<?> property, Number lod, EnumSet<GeometryType> allowedTypes) {
        return property != null ? this.getGeometry(property.getObject(), lod, allowedTypes) : null;
    }

    public ObjectNode getGeometry(AbstractGeometry geometry, Number lod, EnumSet<GeometryType> allowedTypes) {
        return this.geometrySerializer.getGeometry(geometry, lod, allowedTypes);
    }

    public void addTemplateGeometry(ImplicitGeometryProperty property, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        if (property != null) {
            this.addTemplateGeometry((ImplicitGeometry)property.getObject(), lod, object, allowedTypes);
        }
    }

    public void addTemplateGeometry(ImplicitGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        this.geometrySerializer.addTemplateGeometry(geometry, lod, object, allowedTypes);
    }

    public void addGeometries(AbstractSpace space, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        GeometryInfo geometryInfo = space.getGeometryInfo();
        for (int lod = 0; lod < 4; ++lod) {
            for (GeometryProperty property : geometryInfo.getGeometries(lod)) {
                this.addGeometry(property, (Number)lod, object, allowedTypes);
            }
        }
        for (ADEOfAbstractSpace adeContainer : space.getADEProperties(ADEOfAbstractSpace.class)) {
            if (!(adeContainer instanceof ExtendedSpaceGeometry)) continue;
            ExtendedSpaceGeometry geometry = (ExtendedSpaceGeometry)adeContainer;
            this.addGeometry((GeometryProperty<?>)geometry.getLod1MultiSurface(), (Number)1, object, allowedTypes);
            break;
        }
        if (!geometryInfo.hasGeometries(3)) {
            for (Object property : geometryInfo.getGeometries(4)) {
                this.addGeometry((GeometryProperty<?>)property, (Number)3, object, allowedTypes);
            }
        }
        if (allowedTypes.contains((Object)GeometryType.TEMPLATE_GEOMETRY)) {
            for (int lod = 0; lod < 4; ++lod) {
                for (GeometryProperty property : geometryInfo.getImplicitGeometries(lod)) {
                    this.addTemplateGeometry((ImplicitGeometryProperty)property, (Number)lod, object, allowedTypes);
                }
            }
            if (!geometryInfo.hasImplicitGeometries(3)) {
                for (Object property : geometryInfo.getImplicitGeometries(4)) {
                    this.addTemplateGeometry((ImplicitGeometryProperty)property, (Number)3, object, allowedTypes);
                }
            }
        }
    }

    public void addGeometries(AbstractThematicSurface boundary, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        GeometryInfo geometryInfo = boundary.getGeometryInfo();
        for (int lod = 0; lod < 4; ++lod) {
            for (GeometryProperty property : geometryInfo.getGeometries(lod)) {
                this.addGeometry(property, (Number)lod, object, allowedTypes);
            }
        }
        if (!geometryInfo.hasGeometries(3)) {
            for (GeometryProperty property : geometryInfo.getGeometries(4)) {
                this.addGeometry(property, (Number)3, object, allowedTypes);
            }
        }
    }

    public <T extends ADEProperty> void addADEProperty(T property, ObjectNode node) throws CityJSONSerializeException, CityJSONWriteException {
        JsonObjectSerializer<?> serializer;
        if (property != null && (serializer = this.context.getSerializer(property.getClass(), this.version)) != null) {
            this.getObjectUsingSerializer(property, node, serializer);
        }
    }

    public void addExtraRootProperty(ADEOfCityModel property) throws CityJSONSerializeException, CityJSONWriteException {
        this.addADEProperty(property, this.getExtraRootProperties());
    }

    public void addExtraRootProperty(String propertyName, JsonNode value) {
        this.getExtraRootProperties().set(propertyName, value);
    }

    public void writeStandardObjectClassifier(StandardObjectClassifier object, ObjectNode node) {
        if (object.getClassifier() != null) {
            node.put("class", object.getClassifier().getValue());
        }
        if (object.isSetFunctions()) {
            for (Code function : object.getFunctions()) {
                if (function.getValue() == null) continue;
                node.put("function", function.getValue());
                break;
            }
        }
        if (object.isSetUsages()) {
            for (Code usage : object.getUsages()) {
                if (usage.getValue() == null) continue;
                node.put("usage", usage.getValue());
                break;
            }
        }
    }

    public <T> ObjectNode getObject(T object) throws CityJSONSerializeException, CityJSONWriteException {
        JsonObjectSerializer<?> serializer;
        if (object != null && (serializer = this.context.getSerializer(object.getClass(), this.version)) != null) {
            return this.getObjectUsingSerializer(object, serializer);
        }
        return null;
    }

    public <T> ObjectNode getObjectUsingSerializer(T object, Class<? extends JsonObjectSerializer<T>> type) throws CityJSONSerializeException, CityJSONWriteException {
        return this.getObjectUsingSerializer(object, this.getOrCreateSerializer(type));
    }

    public <T> ObjectNode getObjectUsingSerializer(T object, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        return this.getObjectUsingSerializer(object, this.objectMapper.createObjectNode(), serializer);
    }

    private <T> ObjectNode getObjectUsingSerializer(T object, ObjectNode node, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        if (object != null) {
            String type = serializer.createType(object, this.version);
            if (type != null) {
                node.put("type", serializer.createType(object, this.version));
            }
            serializer.writeObject(object, node, this);
            return node;
        }
        return null;
    }

    public <T> JsonObjectSerializer<T> getOrCreateSerializer(Class<? extends JsonObjectSerializer<T>> type) throws CityJSONSerializeException {
        JsonObjectSerializer<?> cachedSerializer = this.serializerCache.get(type);
        if (cachedSerializer != null && type.isAssignableFrom(cachedSerializer.getClass())) {
            return type.cast(cachedSerializer);
        }
        try {
            JsonObjectSerializer<T> serializer = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.serializerCache.put(type, serializer);
            return serializer;
        }
        catch (Exception e) {
            throw new CityJSONSerializeException("The serializer " + type.getName() + " lacks a default constructor.");
        }
    }

    public <T extends AbstractFeature> void writeCityObject(FeatureProperty<T> property) throws CityJSONSerializeException, CityJSONWriteException {
        if (property != null) {
            this.writeCityObject((AbstractFeature)property.getObject());
        }
    }

    public <T extends AbstractFeature> void writeCityObject(T object) throws CityJSONSerializeException, CityJSONWriteException {
        JsonObjectSerializer<?> serializer;
        if (object != null && (serializer = this.context.getSerializer(object.getClass(), this.version)) != null) {
            this.writeCityObjectUsingSerializer(object, serializer);
        }
    }

    public <T extends AbstractFeature> void writeCityObjectUsingSerializer(FeatureProperty<T> property, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        if (property != null) {
            this.writeCityObjectUsingSerializer((AbstractFeature)property.getObject(), serializer);
        }
    }

    public <T extends AbstractFeature> void writeCityObjectUsingSerializer(T object, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        if (object != null) {
            this.writer.beginTopLevelObject();
            String id = this.getOrCreateId((AbstractGML)object);
            ObjectNode node = this.getCityObjectUsingSerializer(object, serializer);
            if (!node.path("type").isNull()) {
                this.writer.writeCityObject(id, this.removeEmptyProperties(node));
            }
        }
    }

    public <T extends AbstractFeature> void writeChildObject(FeatureProperty<T> property, AbstractFeature parent, ObjectNode parentNode) throws CityJSONSerializeException, CityJSONWriteException {
        if (property != null) {
            this.writeChildObject((AbstractFeature)property.getObject(), parent, parentNode);
        }
    }

    public <T extends AbstractFeature> void writeChildObject(T child, AbstractFeature parent, ObjectNode parentNode) throws CityJSONSerializeException, CityJSONWriteException {
        JsonObjectSerializer<?> serializer;
        if (child != null && (serializer = this.context.getSerializer(child.getClass(), this.version)) != null) {
            this.writeChildObjectUsingSerializer(child, parent, parentNode, serializer);
        }
    }

    public <T extends AbstractFeature> void writeChildObjectUsingSerializer(FeatureProperty<T> property, AbstractFeature parent, ObjectNode parentNode, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        if (property != null) {
            this.writeChildObjectUsingSerializer((AbstractFeature)property.getObject(), parent, parentNode, serializer);
        }
    }

    public <T extends AbstractFeature> void writeChildObjectUsingSerializer(T child, AbstractFeature parent, ObjectNode parentNode, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        if (child != null && parent != null && parentNode != null) {
            String childId = this.getOrCreateId((AbstractGML)child);
            String parentId = this.getOrCreateId((AbstractGML)parent);
            ObjectNode childNode = this.getCityObjectUsingSerializer(child, serializer);
            if (!childNode.path("type").isNull()) {
                this.getOrPutArray("parents", childNode).add(parentId);
                this.getOrPutArray("children", parentNode).add(childId);
                this.writer.writeChildObject(childId, this.removeEmptyProperties(childNode));
            }
        }
    }

    private <T extends AbstractFeature> ObjectNode getCityObjectUsingSerializer(T object, JsonObjectSerializer<T> serializer) throws CityJSONSerializeException, CityJSONWriteException {
        ObjectNode node = this.objectMapper.createObjectNode();
        node.set("type", (JsonNode)NullNode.getInstance());
        node.set("geographicalExtent", (JsonNode)this.createArray());
        node.set("attributes", (JsonNode)this.createObject());
        node.set("parents", (JsonNode)this.createArray());
        node.set("children", (JsonNode)this.createArray());
        node.set("geometry", (JsonNode)this.createArray());
        SpaceGeometryBuilder builder = null;
        if (object instanceof AbstractSpace) {
            AbstractSpace space = (AbstractSpace)object;
            builder = SpaceGeometryBuilder.newInstance();
            if (serializer instanceof AbstractSpaceAdapter) {
                AbstractSpaceAdapter spaceAdapter = (AbstractSpaceAdapter)serializer;
                builder.withMultiSurfaceProviders(spaceAdapter.getMultiSurfaceProviders(space)).withMultiCurveProviders(spaceAdapter.getMultiCurveProviders(space));
            }
            builder.addUnreferencedBoundaryGeometries(space);
        }
        this.getObjectUsingSerializer(object, node, serializer);
        if (builder != null) {
            builder.removeTemporaryInformation((AbstractSpace)object);
        }
        return node;
    }

    private ObjectNode removeEmptyProperties(ObjectNode node) {
        this.removeIfEmpty("geographicalExtent", node);
        this.removeIfEmpty("attributes", node);
        this.removeIfEmpty("parents", node);
        this.removeIfEmpty("children", node);
        if (this.version != CityJSONVersion.v1_0) {
            this.removeIfEmpty("geometry", node);
        }
        return node;
    }

    List<Double> computeExtent(ArrayBuffer<Vertex> vertices) {
        Double[] extent = new Double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
        for (Vertex vertex : vertices) {
            double x = vertex.getX();
            double y = vertex.getY();
            double z = vertex.getZ();
            if (x < extent[0]) {
                extent[0] = x;
            }
            if (y < extent[1]) {
                extent[1] = y;
            }
            if (z < extent[2]) {
                extent[2] = z;
            }
            if (x > extent[3]) {
                extent[3] = x;
            }
            if (y > extent[4]) {
                extent[4] = y;
            }
            if (!(z > extent[5])) continue;
            extent[5] = z;
        }
        return Arrays.asList(extent);
    }

    String getReferenceSystem(AbstractFeature feature) {
        AbstractFeature parent = feature;
        do {
            AbstractFeature tmp;
            if (!(parent instanceof AbstractFeature) || (tmp = parent).getBoundedBy() == null || tmp.getBoundedBy().getEnvelope() == null || tmp.getBoundedBy().getEnvelope().getSrsName() == null) continue;
            return tmp.getBoundedBy().getEnvelope().getSrsName();
        } while ((parent = parent.getParent()) != null);
        final String[] reference = new String[1];
        feature.accept((ObjectVisitor)new ObjectWalker(){

            public void visit(AbstractFeature feature) {
                if (feature.getBoundedBy() != null && feature.getBoundedBy().getEnvelope() != null && feature.getBoundedBy().getEnvelope().getSrsName() != null) {
                    reference[0] = feature.getBoundedBy().getEnvelope().getSrsName();
                    this.shouldWalk = false;
                    return;
                }
                super.visit(feature);
            }
        });
        return reference[0];
    }

    void reset() {
        this.reset(false);
    }

    void reset(boolean keepTemplates) {
        this.serializerCache.clear();
        this.geometrySerializer.reset(keepTemplates);
        this.appearanceSerializer.reset();
    }
}

