/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.citygml4j.core.ade.ADEException;
import org.citygml4j.core.ade.ADELoader;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.xml.CityGMLContext;
import org.citygml4j.xml.ade.CityGMLADE;
import org.citygml4j.xml.module.ade.ADEModule;

public class CityGMLADELoader
extends ADELoader<CityGMLADE> {
    private final Map<CityGMLVersion, Map<String, ADEModule>> modules = new ConcurrentHashMap<CityGMLVersion, Map<String, ADEModule>>();
    private final Map<CityGMLContext, Boolean> listeners = Collections.synchronizedMap(new WeakHashMap());

    public List<ADEModule> getADEModules() {
        return this.modules.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ADEModule> getADEModules(CityGMLVersion version) {
        return new ArrayList<ADEModule>(this.modules.getOrDefault(version, Collections.emptyMap()).values());
    }

    public ADEModule getADEModule(String namespaceURI) {
        for (Map<String, ADEModule> value : this.modules.values()) {
            ADEModule module = value.get(namespaceURI);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public ADEModule getADEModule(String namespaceURI, CityGMLVersion version) {
        return (ADEModule)this.modules.getOrDefault(version, Collections.emptyMap()).get(namespaceURI);
    }

    public Set<String> getADENamespaces() {
        return this.modules.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected void loadADE(CityGMLADE ade) throws ADEException {
        List<ADEModule> modules = ade.getADEModules();
        if (modules == null || modules.isEmpty()) {
            throw new ADEException("No ADE modules defined for the ADE " + ade.getClass().getName() + ".");
        }
        for (ADEModule module : modules) {
            if (module.getNamespaceURI() == null || module.getNamespaceURI().isEmpty()) {
                throw new ADEException("The ADE " + ade.getClass().getName() + " defines an ADE module without a namespace URI.");
            }
            if (module.getCityGMLVersion() == null) {
                throw new ADEException("The ADE " + ade.getClass().getName() + " defines an ADE module without a CityGML version.");
            }
            if (this.modules.getOrDefault(module.getCityGMLVersion(), Collections.emptyMap()).get(module.getNamespaceURI()) != null) {
                throw new ADEException("An ADE module has already been registered for the namespace '" + module.getNamespaceURI() + "' and the CityGML version " + module.getCityGMLVersion() + ".");
            }
            this.modules.computeIfAbsent(module.getCityGMLVersion(), v -> new ConcurrentHashMap()).put(module.getNamespaceURI(), module);
        }
        for (CityGMLContext listener : this.listeners.keySet()) {
            listener.loadADE(ade);
        }
    }

    protected void unloadADE(CityGMLADE ade) throws ADEException {
        for (ADEModule module : ade.getADEModules()) {
            this.modules.getOrDefault(module.getCityGMLVersion(), Collections.emptyMap()).remove(module.getNamespaceURI());
        }
        this.listeners.keySet().forEach(v -> v.unloadADE(ade));
    }

    void addListener(CityGMLContext context) {
        this.listeners.put(context, Boolean.TRUE);
    }
}

