/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.appearance;

import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfX3DMaterial;
import org.citygml4j.core.model.appearance.ADEOfX3DMaterial;
import org.citygml4j.core.model.appearance.Color;
import org.citygml4j.core.model.appearance.GeometryReference;
import org.citygml4j.core.model.appearance.X3DMaterial;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.appearance.AbstractSurfaceDataAdapter;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.annotation.XMLElements;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

@XMLElements(value={@XMLElement(name="X3DMaterial", namespaceURI="http://www.opengis.net/citygml/appearance/3.0"), @XMLElement(name="X3DMaterial", namespaceURI="http://www.opengis.net/citygml/appearance/2.0"), @XMLElement(name="X3DMaterial", namespaceURI="http://www.opengis.net/citygml/appearance/1.0")})
public class X3DMaterialAdapter
extends AbstractSurfaceDataAdapter<X3DMaterial> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/appearance/2.0", "_GenericApplicationPropertyOfX3DMaterial"), new QName("http://www.opengis.net/citygml/appearance/1.0", "_GenericApplicationPropertyOfX3DMaterial")};

    public X3DMaterial createObject(QName name, Object parent) throws ObjectBuildException {
        return new X3DMaterial();
    }

    @Override
    public void buildChildObject(X3DMaterial object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isAppearanceNamespace(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "ambientIntensity": {
                    reader.getTextContent().ifDouble(arg_0 -> ((X3DMaterial)object).setAmbientIntensity(arg_0));
                    return;
                }
                case "diffuseColor": {
                    reader.getTextContent().ifDoubleList(v -> object.setDiffuseColor(Color.fromList((List)v)));
                    return;
                }
                case "emissiveColor": {
                    reader.getTextContent().ifDoubleList(v -> object.setEmissiveColor(Color.fromList((List)v)));
                    return;
                }
                case "specularColor": {
                    reader.getTextContent().ifDoubleList(v -> object.setSpecularColor(Color.fromList((List)v)));
                    return;
                }
                case "shininess": {
                    reader.getTextContent().ifDouble(arg_0 -> ((X3DMaterial)object).setShininess(arg_0));
                    return;
                }
                case "transparency": {
                    reader.getTextContent().ifDouble(arg_0 -> ((X3DMaterial)object).setTransparency(arg_0));
                    return;
                }
                case "isSmooth": {
                    reader.getTextContent().ifBoolean(arg_0 -> ((X3DMaterial)object).setIsSmooth(arg_0));
                    return;
                }
                case "target": {
                    reader.getTextContent().ifPresent(v -> object.getTargets().add(new GeometryReference(v)));
                    return;
                }
                case "adeOfX3DMaterial": {
                    ADEBuilderHelper.addADEProperty((AbstractFeature)object, GenericADEOfX3DMaterial::of, reader);
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(X3DMaterial object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty((AbstractFeature)object, name, GenericADEOfX3DMaterial::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    public Element createElement(X3DMaterial object, Namespaces namespaces) throws ObjectSerializeException {
        return Element.of((String)CityGMLSerializerHelper.getAppearanceNamespace(namespaces), (String)"X3DMaterial");
    }

    @Override
    public void writeChildElements(X3DMaterial object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String appearanceNamespace = CityGMLSerializerHelper.getAppearanceNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/appearance/3.0".equalsIgnoreCase(appearanceNamespace);
        if (object.isSetAmbientIntensity()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"ambientIntensity").addTextContent(TextContent.ofDouble((Double)object.getAmbientIntensity())));
        }
        if (object.isSetDiffuseColor()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"diffuseColor").addTextContent(TextContent.ofDoubleList((List)object.getDiffuseColor().toList())));
        }
        if (object.isSetEmissiveColor()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"emissiveColor").addTextContent(TextContent.ofDoubleList((List)object.getEmissiveColor().toList())));
        }
        if (object.isSetSpecularColor()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"specularColor").addTextContent(TextContent.ofDoubleList((List)object.getSpecularColor().toList())));
        }
        if (object.isSetShininess()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"shininess").addTextContent(TextContent.ofDouble((Double)object.getShininess())));
        }
        if (object.isSetTransparency()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"transparency").addTextContent(TextContent.ofDouble((Double)object.getTransparency())));
        }
        if (object.isSetIsSmooth()) {
            writer.writeElement(Element.of((String)appearanceNamespace, (String)"isSmooth").addTextContent(TextContent.ofBoolean((Boolean)object.getIsSmooth())));
        }
        if (object.isSetTargets()) {
            for (GeometryReference target : object.getTargets()) {
                if (target == null) continue;
                writer.writeElement(Element.of((String)appearanceNamespace, (String)"target").addTextContent(target.getHref()));
            }
        }
        for (ADEOfX3DMaterial property : object.getADEProperties(ADEOfX3DMaterial.class)) {
            ADESerializerHelper.writeADEProperty(isCityGML3 ? Element.of((String)appearanceNamespace, (String)"adeOfX3DMaterial") : null, (ADEProperty)property, namespaces, writer);
        }
    }
}

