/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.deprecated.building;

import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractBuilding;
import org.citygml4j.core.model.building.ADEOfAbstractBuilding;
import org.citygml4j.core.model.building.AbstractBuilding;
import org.citygml4j.core.model.building.Building;
import org.citygml4j.core.model.building.BuildingInstallation;
import org.citygml4j.core.model.building.BuildingInstallationProperty;
import org.citygml4j.core.model.building.BuildingPartProperty;
import org.citygml4j.core.model.building.BuildingRoomProperty;
import org.citygml4j.core.model.construction.Height;
import org.citygml4j.core.model.construction.HeightProperty;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.core.AddressProperty;
import org.citygml4j.core.model.deprecated.building.DeprecatedPropertiesOfAbstractBuilding;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.building.BuildingInstallationPropertyAdapter;
import org.citygml4j.xml.adapter.building.BuildingPartPropertyAdapter;
import org.citygml4j.xml.adapter.building.BuildingRoomPropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractSpaceBoundaryPropertyAdapter;
import org.citygml4j.xml.adapter.core.AddressPropertyAdapter;
import org.citygml4j.xml.adapter.deprecated.building.AbstractBoundarySurfacePropertyAdapter;
import org.citygml4j.xml.adapter.deprecated.core.AbstractSiteAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.basictypes.CodeAdapter;
import org.xmlobjects.gml.adapter.basictypes.MeasureOrNilReasonListAdapter;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiCurvePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSurfacePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.primitives.SolidPropertyAdapter;
import org.xmlobjects.gml.adapter.measures.LengthAdapter;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.basictypes.MeasureOrNilReasonList;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;
import org.xmlobjects.gml.model.measures.Length;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractBuildingAdapter<T extends AbstractBuilding>
extends AbstractSiteAdapter<T> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/building/2.0", "_GenericApplicationPropertyOfAbstractBuilding"), new QName("http://www.opengis.net/citygml/building/1.0", "_GenericApplicationPropertyOfAbstractBuilding")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isBuildingNamespace(name.getNamespaceURI())) {
            if (CityGMLBuilderHelper.buildStandardObjectClassifier(object, name.getLocalPart(), reader)) {
                return;
            }
            switch (name.getLocalPart()) {
                case "yearOfConstruction": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfConstruction(v.toLocalDate()));
                    return;
                }
                case "yearOfDemolition": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfDemolition(v.toLocalDate()));
                    return;
                }
                case "roofType": {
                    object.setRoofType((Code)reader.getObjectUsingBuilder(CodeAdapter.class));
                    return;
                }
                case "measuredHeight": {
                    object.getHeights().add(new HeightProperty(Height.ofMeasuredHeight((Length)((Length)reader.getObjectUsingBuilder(LengthAdapter.class)))));
                    return;
                }
                case "storeysAboveGround": {
                    reader.getTextContent().ifInteger(arg_0 -> object.setStoreysAboveGround(arg_0));
                    return;
                }
                case "storeysBelowGround": {
                    reader.getTextContent().ifInteger(arg_0 -> object.setStoreysBelowGround(arg_0));
                    return;
                }
                case "storeyHeightsAboveGround": {
                    object.setStoreyHeightsAboveGround((MeasureOrNilReasonList)reader.getObjectUsingBuilder(MeasureOrNilReasonListAdapter.class));
                    return;
                }
                case "storeyHeightsBelowGround": {
                    object.setStoreyHeightsBelowGround((MeasureOrNilReasonList)reader.getObjectUsingBuilder(MeasureOrNilReasonListAdapter.class));
                    return;
                }
                case "lod0FootPrint": {
                    object.setLod0MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod0RoofEdge": {
                    object.getDeprecatedProperties().setLod0RoofEdge((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod1Solid": {
                    object.setLod1Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod1MultiSurface": {
                    object.getDeprecatedProperties().setLod1MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod1TerrainIntersection": {
                    object.setLod1TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2Solid": {
                    object.setLod2Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod2MultiSurface": {
                    object.setLod2MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod2MultiCurve": {
                    object.setLod2MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2TerrainIntersection": {
                    object.setLod2TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "outerBuildingInstallation": 
                case "interiorBuildingInstallation": {
                    object.getBuildingInstallations().add((BuildingInstallationProperty)reader.getObjectUsingBuilder(BuildingInstallationPropertyAdapter.class));
                    return;
                }
                case "boundedBy": {
                    object.addBoundary((AbstractSpaceBoundaryProperty)reader.getObjectUsingBuilder(AbstractSpaceBoundaryPropertyAdapter.class));
                    return;
                }
                case "lod3Solid": {
                    object.setLod3Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod3MultiSurface": {
                    object.setLod3MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod3MultiCurve": {
                    object.setLod3MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod3TerrainIntersection": {
                    object.setLod3TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4Solid": {
                    object.getDeprecatedProperties().setLod4Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod4MultiSurface": {
                    object.getDeprecatedProperties().setLod4MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod4MultiCurve": {
                    object.getDeprecatedProperties().setLod4MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4TerrainIntersection": {
                    object.getDeprecatedProperties().setLod4TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "interiorRoom": {
                    object.getBuildingRooms().add((BuildingRoomProperty)reader.getObjectUsingBuilder(BuildingRoomPropertyAdapter.class));
                    return;
                }
                case "consistsOfBuildingPart": {
                    BuildingPartProperty consistsOfBuildingPart = (BuildingPartProperty)reader.getObjectUsingBuilder(BuildingPartPropertyAdapter.class);
                    if ((consistsOfBuildingPart.getObject() != null || consistsOfBuildingPart.getGenericElement() != null) && object instanceof Building) {
                        ((Building)object).getBuildingParts().add(consistsOfBuildingPart);
                    } else {
                        object.getDeprecatedProperties().getConsistsOfBuildingParts().add(consistsOfBuildingPart);
                    }
                    return;
                }
                case "address": {
                    object.getAddresses().add((AddressProperty)reader.getObjectUsingBuilder(AddressPropertyAdapter.class));
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractBuilding::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        Building building;
        Object height;
        super.writeChildElements(object, namespaces, writer);
        String buildingNamespace = CityGMLSerializerHelper.getBuildingNamespace(namespaces);
        DeprecatedPropertiesOfAbstractBuilding properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        CityGMLSerializerHelper.writeStandardObjectClassifier(object, buildingNamespace, namespaces, writer);
        if (object.getDateOfConstruction() != null) {
            writer.writeElement(Element.of((String)buildingNamespace, (String)"yearOfConstruction").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfConstruction(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.getDateOfDemolition() != null) {
            writer.writeElement(Element.of((String)buildingNamespace, (String)"yearOfDemolition").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfDemolition(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.getRoofType() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"roofType"), (Object)object.getRoofType(), CodeAdapter.class, namespaces);
        }
        if (object.isSetHeights() && (height = (Height)((HeightProperty)object.getHeights().get(0)).getObject()) != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"measuredHeight"), (Object)height.getValue(), LengthAdapter.class, namespaces);
        }
        if (object.getStoreysAboveGround() != null) {
            writer.writeElement(Element.of((String)buildingNamespace, (String)"storeysAboveGround").addTextContent(TextContent.ofInteger((Integer)object.getStoreysAboveGround())));
        }
        if (object.getStoreysBelowGround() != null) {
            writer.writeElement(Element.of((String)buildingNamespace, (String)"storeysBelowGround").addTextContent(TextContent.ofInteger((Integer)object.getStoreysBelowGround())));
        }
        if (object.getStoreyHeightsAboveGround() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"storeyHeightsAboveGround"), (Object)object.getStoreyHeightsAboveGround(), MeasureOrNilReasonListAdapter.class, namespaces);
        }
        if (object.getStoreyHeightsBelowGround() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"storeyHeightsBelowGround"), (Object)object.getStoreyHeightsBelowGround(), MeasureOrNilReasonListAdapter.class, namespaces);
        }
        if (object.getLod0MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod0FootPrint"), (Object)object.getLod0MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod0RoofEdge() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod0RoofEdge"), (Object)properties.getLod0RoofEdge(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod1Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod1Solid"), (Object)object.getLod1Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod1MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod1MultiSurface"), (Object)properties.getLod1MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod1TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod1TerrainIntersection"), (Object)object.getLod1TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod2Solid"), (Object)object.getLod2Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod2MultiSurface"), (Object)object.getLod2MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod2MultiCurve"), (Object)object.getLod2MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod2TerrainIntersection"), (Object)object.getLod2TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetBuildingInstallations()) {
            for (Object property : object.getBuildingInstallations()) {
                if (property.getObject() != null && ((BuildingInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.INSIDE) {
                    writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"outerBuildingInstallation"), property, BuildingInstallationPropertyAdapter.class, namespaces);
                    continue;
                }
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"interiorBuildingInstallation"), property, BuildingInstallationPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetBoundaries()) {
            for (Object property : object.getBoundaries()) {
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"boundedBy"), property, AbstractBoundarySurfacePropertyAdapter.class, namespaces);
            }
        }
        if (object.getLod3Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod3Solid"), (Object)object.getLod3Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod3MultiSurface"), (Object)object.getLod3MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod3MultiCurve"), (Object)object.getLod3MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod3TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod3TerrainIntersection"), (Object)object.getLod3TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod4Solid"), (Object)properties.getLod4Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod4MultiSurface"), (Object)properties.getLod4MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod4MultiCurve"), (Object)properties.getLod4MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"lod4TerrainIntersection"), (Object)properties.getLod4TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetBuildingRooms()) {
            for (Object property : object.getBuildingRooms()) {
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"interiorRoom"), property, BuildingRoomPropertyAdapter.class, namespaces);
            }
        }
        if (object instanceof Building && (building = (Building)object).isSetBuildingParts()) {
            for (BuildingPartProperty property : building.getBuildingParts()) {
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"consistsOfBuildingPart"), (Object)property, BuildingPartPropertyAdapter.class, namespaces);
            }
        }
        if (properties != null && properties.isSetConsistsOfBuildingParts()) {
            for (Object property : properties.getConsistsOfBuildingParts()) {
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"consistsOfBuildingPart"), property, BuildingPartPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetAddresses()) {
            for (Object property : object.getAddresses()) {
                writer.writeElementUsingSerializer(Element.of((String)buildingNamespace, (String)"address"), property, AddressPropertyAdapter.class, namespaces);
            }
        }
        for (Object property : object.getADEProperties(ADEOfAbstractBuilding.class)) {
            ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
        }
    }
}

