/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.deprecated.transportation;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractTransportationSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.transportation.DeprecatedPropertiesOfAbstractTransportationSpace;
import org.citygml4j.core.model.transportation.ADEOfAbstractTransportationSpace;
import org.citygml4j.core.model.transportation.AbstractTransportationSpace;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficArea;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficSpace;
import org.citygml4j.core.model.transportation.AuxiliaryTrafficSpaceProperty;
import org.citygml4j.core.model.transportation.GranularityValue;
import org.citygml4j.core.model.transportation.TrafficArea;
import org.citygml4j.core.model.transportation.TrafficSpace;
import org.citygml4j.core.model.transportation.TrafficSpaceProperty;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.core.AbstractCityObjectAdapter;
import org.citygml4j.xml.adapter.core.AbstractSpaceBoundaryPropertyAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSurfacePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.complexes.GeometricComplexPropertyAdapter;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurve;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.complexes.CompositeCurve;
import org.xmlobjects.gml.model.geometry.complexes.GeometricComplexProperty;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurve;
import org.xmlobjects.gml.model.geometry.primitives.CurveProperty;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.util.copy.CopyBuilder;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public abstract class AbstractTransportationObjectAdapter<T extends AbstractTransportationSpace>
extends AbstractCityObjectAdapter<T> {
    private final CopyBuilder copyBuilder = new CopyBuilder();
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/transportation/2.0", "_GenericApplicationPropertyOfTransportationObject"), new QName("http://www.opengis.net/citygml/transportation/1.0", "_GenericApplicationPropertyOfTransportationObject"), new QName("http://www.opengis.net/citygml/transportation/2.0", "_GenericApplicationPropertyOfTransportationComplex"), new QName("http://www.opengis.net/citygml/transportation/1.0", "_GenericApplicationPropertyOfTransportationComplex")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isTransportationNamespace(name.getNamespaceURI())) {
            if (object instanceof StandardObjectClassifier && CityGMLBuilderHelper.buildStandardObjectClassifier((StandardObjectClassifier)object, name.getLocalPart(), reader)) {
                return;
            }
            switch (name.getLocalPart()) {
                case "trafficArea": {
                    AbstractSpaceBoundaryProperty trafficArea = (AbstractSpaceBoundaryProperty)reader.getObjectUsingBuilder(AbstractSpaceBoundaryPropertyAdapter.class);
                    TrafficSpace trafficSpace = new TrafficSpace(GranularityValue.WAY);
                    trafficSpace.addBoundary(trafficArea);
                    object.getTrafficSpaces().add(new TrafficSpaceProperty(trafficSpace));
                    return;
                }
                case "auxiliaryTrafficArea": {
                    AbstractSpaceBoundaryProperty auxiliaryTrafficArea = (AbstractSpaceBoundaryProperty)reader.getObjectUsingBuilder(AbstractSpaceBoundaryPropertyAdapter.class);
                    AuxiliaryTrafficSpace auxiliaryTrafficSpace = new AuxiliaryTrafficSpace(GranularityValue.WAY);
                    auxiliaryTrafficSpace.addBoundary(auxiliaryTrafficArea);
                    object.getAuxiliaryTrafficSpaces().add(new AuxiliaryTrafficSpaceProperty(auxiliaryTrafficSpace));
                    return;
                }
                case "lod0Network": {
                    GeometricComplexProperty property = (GeometricComplexProperty)reader.getObjectUsingBuilder(GeometricComplexPropertyAdapter.class);
                    if (property.isSetCompositeCurve()) {
                        object.setLod0MultiCurve(this.getMultiCurveProperty(property.getCompositeCurve()));
                    } else {
                        object.getDeprecatedProperties().setLod0Network(property);
                    }
                    return;
                }
                case "lod1MultiSurface": {
                    object.getDeprecatedProperties().setLod1MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod2MultiSurface": {
                    object.setLod2MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod3MultiSurface": {
                    object.setLod3MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod4MultiSurface": {
                    object.getDeprecatedProperties().setLod4MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractTransportationSpace::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        DeprecatedPropertiesOfAbstractTransportationSpace properties;
        super.writeChildElements(object, namespaces, writer);
        String transportationNamespace = CityGMLSerializerHelper.getTransportationNamespace(namespaces);
        DeprecatedPropertiesOfAbstractTransportationSpace deprecatedPropertiesOfAbstractTransportationSpace = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        if (object instanceof StandardObjectClassifier) {
            CityGMLSerializerHelper.writeStandardObjectClassifier((StandardObjectClassifier)object, transportationNamespace, namespaces, writer);
        }
        if (object.isSetTrafficSpaces()) {
            for (TrafficSpaceProperty property : object.getTrafficSpaces()) {
                TrafficSpace trafficSpace;
                if (property.getObject() == null || !(trafficSpace = (TrafficSpace)property.getObject()).isSetBoundaries()) continue;
                for (AbstractSpaceBoundaryProperty boundary : trafficSpace.getBoundaries()) {
                    if (boundary.isSetInlineObject() && !(boundary.getObject() instanceof TrafficArea)) continue;
                    writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"trafficArea"), (Object)boundary, AbstractSpaceBoundaryPropertyAdapter.class, namespaces);
                }
            }
        }
        if (object.isSetAuxiliaryTrafficSpaces()) {
            for (TrafficSpaceProperty property : object.getAuxiliaryTrafficSpaces()) {
                AuxiliaryTrafficSpace auxiliaryTrafficSpace;
                if (property.getObject() == null || !(auxiliaryTrafficSpace = (AuxiliaryTrafficSpace)property.getObject()).isSetBoundaries()) continue;
                for (AbstractSpaceBoundaryProperty boundary : auxiliaryTrafficSpace.getBoundaries()) {
                    if (boundary.isSetInlineObject() && !(boundary.getObject() instanceof AuxiliaryTrafficArea)) continue;
                    writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"auxiliaryTrafficArea"), (Object)boundary, AbstractSpaceBoundaryPropertyAdapter.class, namespaces);
                }
            }
        }
        if (properties != null && properties.getLod0Network() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod0Network"), (Object)properties.getLod0Network(), GeometricComplexPropertyAdapter.class, namespaces);
        } else if (object.getLod0MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod0Network"), (Object)this.getGeometricComplexProperty(object.getLod0MultiCurve()), GeometricComplexPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod1MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod1MultiSurface"), (Object)properties.getLod1MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod2MultiSurface"), (Object)object.getLod2MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod3MultiSurface"), (Object)object.getLod3MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)transportationNamespace, (String)"lod4MultiSurface"), (Object)properties.getLod4MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        for (TrafficSpaceProperty property : object.getADEProperties(ADEOfAbstractTransportationSpace.class)) {
            ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
        }
    }

    private MultiCurveProperty getMultiCurveProperty(CompositeCurve src) {
        MultiCurve multiCurve = new MultiCurve();
        multiCurve.setCurveMember(src.getCurveMembers());
        return new MultiCurveProperty(multiCurve);
    }

    private GeometricComplexProperty getGeometricComplexProperty(MultiCurveProperty src) {
        GeometricComplexProperty dest;
        if (src.getObject() != null) {
            MultiCurve multiCurve = (MultiCurve)src.getObject();
            ArrayList<CurveProperty> properties = new ArrayList<CurveProperty>();
            if (multiCurve.isSetCurveMember()) {
                for (CurveProperty property : multiCurve.getCurveMember()) {
                    properties.add((CurveProperty)property.shallowCopy(this.copyBuilder));
                }
            }
            if (multiCurve.getCurveMembers() != null && multiCurve.getCurveMembers().isSetObjects()) {
                for (AbstractCurve curve : multiCurve.getCurveMembers().getObjects()) {
                    properties.add(new CurveProperty((AbstractCurve)curve.shallowCopy(this.copyBuilder)));
                }
            }
            dest = properties.size() == 0 ? new GeometricComplexProperty() : new GeometricComplexProperty((AbstractGeometry)new CompositeCurve(properties));
        } else {
            dest = new GeometricComplexProperty();
        }
        return dest;
    }
}

