/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.deprecated.waterbody;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractThematicSurface;
import org.citygml4j.core.model.core.ADEOfAbstractThematicSurface;
import org.citygml4j.core.model.core.AbstractThematicSurface;
import org.citygml4j.core.model.waterbody.ADEOfAbstractWaterBoundarySurface;
import org.citygml4j.core.model.waterbody.AbstractWaterBoundarySurface;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.core.AbstractCityObjectAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.geometry.primitives.SurfacePropertyAdapter;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSurface;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.util.copy.CopyBuilder;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public abstract class AbstractWaterBoundarySurfaceAdapter<T extends AbstractThematicSurface>
extends AbstractCityObjectAdapter<T> {
    private final CopyBuilder copyBuilder = new CopyBuilder();
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/waterbody/2.0", "_GenericApplicationPropertyOfWaterBoundarySurface"), new QName("http://www.opengis.net/citygml/waterbody/1.0", "_GenericApplicationPropertyOfWaterBoundarySurface")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isWaterBodyNamespace(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "lod2Surface": {
                    object.setLod2MultiSurface(this.getMultiSurfaceProperty((SurfaceProperty)reader.getObjectUsingBuilder(SurfacePropertyAdapter.class)));
                    return;
                }
                case "lod3Surface": {
                    object.setLod3MultiSurface(this.getMultiSurfaceProperty((SurfaceProperty)reader.getObjectUsingBuilder(SurfacePropertyAdapter.class)));
                    return;
                }
                case "lod4Surface": {
                    object.getDeprecatedProperties().setLod4MultiSurface(this.getMultiSurfaceProperty((SurfaceProperty)reader.getObjectUsingBuilder(SurfacePropertyAdapter.class)));
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractThematicSurface::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String waterBodyNamespace = CityGMLSerializerHelper.getWaterBodyNamespace(namespaces);
        if (object.getLod2MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)waterBodyNamespace, (String)"lod2Surface"), (Object)this.getSurfaceProperty(object.getLod2MultiSurface()), SurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)waterBodyNamespace, (String)"lod3Surface"), (Object)this.getSurfaceProperty(object.getLod3MultiSurface()), SurfacePropertyAdapter.class, namespaces);
        }
        if (object.hasDeprecatedProperties() && object.getDeprecatedProperties().getLod4MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)waterBodyNamespace, (String)"lod4Surface"), (Object)this.getSurfaceProperty(object.getDeprecatedProperties().getLod4MultiSurface()), SurfacePropertyAdapter.class, namespaces);
        }
        if (object instanceof AbstractWaterBoundarySurface) {
            AbstractWaterBoundarySurface boundarySurface = (AbstractWaterBoundarySurface)object;
            for (ADEOfAbstractWaterBoundarySurface property : boundarySurface.getADEProperties(ADEOfAbstractWaterBoundarySurface.class)) {
                ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
            }
        }
        for (ADEOfAbstractThematicSurface property : object.getADEProperties(ADEOfAbstractThematicSurface.class)) {
            ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
        }
    }

    private MultiSurfaceProperty getMultiSurfaceProperty(SurfaceProperty src) {
        MultiSurface multiSurface = new MultiSurface();
        multiSurface.getSurfaceMember().add(src);
        return new MultiSurfaceProperty(multiSurface);
    }

    private SurfaceProperty getSurfaceProperty(MultiSurfaceProperty src) {
        SurfaceProperty dest;
        if (src.getObject() != null) {
            MultiSurface multiSurface = (MultiSurface)src.getObject();
            ArrayList<SurfaceProperty> properties = new ArrayList<SurfaceProperty>();
            if (multiSurface.isSetSurfaceMember()) {
                for (SurfaceProperty property : multiSurface.getSurfaceMember()) {
                    properties.add((SurfaceProperty)property.shallowCopy(this.copyBuilder));
                }
            }
            if (multiSurface.getSurfaceMembers() != null && multiSurface.getSurfaceMembers().isSetObjects()) {
                for (AbstractSurface surface : multiSurface.getSurfaceMembers().getObjects()) {
                    properties.add(new SurfaceProperty((AbstractSurface)surface.shallowCopy(this.copyBuilder)));
                }
            }
            dest = properties.size() == 0 ? new SurfaceProperty() : (properties.size() == 1 ? (SurfaceProperty)properties.get(0) : new SurfaceProperty((AbstractSurface)new CompositeSurface(properties)));
        } else {
            dest = new SurfaceProperty();
        }
        return dest;
    }
}

