/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.citygml4j.xml.module.citygml.AppearanceModule;
import org.citygml4j.xml.module.citygml.CityObjectGroupModule;
import org.citygml4j.xml.module.citygml.CoreModule;
import org.citygml4j.xml.module.gml.GMLCoreModule;

public class ChunkOptions {
    private final Map<String, Set<String>> properties = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> excludes = new HashMap<String, Set<String>>();
    private boolean skipCityModel = true;
    private boolean keepInlineAppearance = true;

    private ChunkOptions() {
    }

    public static ChunkOptions defaults() {
        return new ChunkOptions().addCityModelMemberProperties().addGroupMemberProperties();
    }

    public static ChunkOptions chunkByFeatures() {
        return new ChunkOptions();
    }

    public static ChunkOptions chunkByProperties(Collection<QName> properties) {
        ChunkOptions chunkOptions = new ChunkOptions();
        if (properties != null) {
            properties.forEach(chunkOptions::withProperty);
        }
        return chunkOptions;
    }

    public static ChunkOptions chunkByProperties(QName ... properties) {
        return ChunkOptions.chunkByProperties(properties != null ? List.of(properties) : null);
    }

    public static ChunkOptions empty() {
        return new ChunkOptions();
    }

    boolean shouldChunk(QName property) {
        return this.properties.isEmpty() || this.containsProperty(property.getNamespaceURI(), property.getLocalPart());
    }

    public boolean containsProperty(String namespaceURI, String localPart) {
        return this.properties.getOrDefault(namespaceURI, Collections.emptySet()).contains(localPart);
    }

    public boolean containsProperty(QName property) {
        return this.containsProperty(property.getNamespaceURI(), property.getLocalPart());
    }

    public ChunkOptions withProperty(String namespaceURI, String localPart) {
        this.properties.computeIfAbsent(namespaceURI, v -> new HashSet()).add(localPart);
        return this;
    }

    public ChunkOptions withProperty(QName property) {
        return this.withProperty(property.getNamespaceURI(), property.getLocalPart());
    }

    public ChunkOptions withProperties(Collection<QName> properties) {
        if (properties != null) {
            properties.forEach(this::withProperty);
        }
        return this;
    }

    public boolean isExcludeFeature(String namespaceURI, String localPart) {
        return this.excludes.getOrDefault(namespaceURI, Collections.emptySet()).contains(localPart);
    }

    public boolean isExcludeFeature(QName feature) {
        return this.isExcludeFeature(feature.getNamespaceURI(), feature.getLocalPart());
    }

    public ChunkOptions excludeFeature(String namespaceURI, String localPart) {
        this.excludes.computeIfAbsent(namespaceURI, v -> new HashSet()).add(localPart);
        return this;
    }

    public ChunkOptions excludeFeature(QName feature) {
        return this.excludeFeature(feature.getNamespaceURI(), feature.getLocalPart());
    }

    public ChunkOptions excludeFeatures(Collection<QName> features) {
        if (features != null) {
            features.forEach(this::excludeFeature);
        }
        return this;
    }

    public boolean isSkipCityModel() {
        return this.skipCityModel;
    }

    public ChunkOptions skipCityModel(boolean skipCityModel) {
        this.skipCityModel = skipCityModel;
        return this;
    }

    public boolean isKeepInlineAppearance() {
        return this.keepInlineAppearance;
    }

    public ChunkOptions keepInlineAppearance(boolean keepInlineAppearance) {
        this.keepInlineAppearance = keepInlineAppearance;
        return this;
    }

    public ChunkOptions addCityModelMemberProperties() {
        return this.withProperty(CoreModule.v3_0.getNamespaceURI(), "cityObjectMember").withProperty(CoreModule.v3_0.getNamespaceURI(), "appearanceMember").withProperty(CoreModule.v3_0.getNamespaceURI(), "featureMember").withProperty(CoreModule.v3_0.getNamespaceURI(), "versionMember").withProperty(CoreModule.v3_0.getNamespaceURI(), "versionTransitionMember").withProperty(CoreModule.v2_0.getNamespaceURI(), "cityObjectMember").withProperty(AppearanceModule.v2_0.getNamespaceURI(), "appearanceMember").withProperty(CoreModule.v1_0.getNamespaceURI(), "cityObjectMember").withProperty(AppearanceModule.v1_0.getNamespaceURI(), "appearanceMember").withProperty(GMLCoreModule.v3_1.getNamespaceURI(), "featureMember").withProperty(GMLCoreModule.v3_1.getNamespaceURI(), "featureMembers");
    }

    public ChunkOptions addGroupMemberProperties() {
        return this.withProperty(CityObjectGroupModule.v2_0.getNamespaceURI(), "groupMember").withProperty(CityObjectGroupModule.v2_0.getNamespaceURI(), "parent").withProperty(CityObjectGroupModule.v1_0.getNamespaceURI(), "groupMember").withProperty(CityObjectGroupModule.v1_0.getNamespaceURI(), "parent");
    }
}

