/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.citygml4j.core.ade.ADERegistry;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.xml.CityGMLADELoader;
import org.citygml4j.xml.CityGMLContext;
import org.citygml4j.xml.module.citygml.CityGMLModules;
import org.citygml4j.xml.module.gml.GMLCoreModule;
import org.citygml4j.xml.module.gml.XLinkModule;
import org.citygml4j.xml.reader.ChunkOptions;
import org.citygml4j.xml.reader.CityGMLChunk;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.citygml4j.xml.reader.CityGMLReader;
import org.citygml4j.xml.reader.FeatureInfo;
import org.xml.sax.SAXException;
import org.xmlobjects.XMLObjects;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.schema.SchemaHandler;
import org.xmlobjects.schema.SchemaWalker;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLReaderFactory;

public class CityGMLChunkReader
extends CityGMLReader {
    private final ChunkOptions chunkOptions;
    private final IdCreator idCreator;
    private final XMLReaderFactory factory;
    private final CityGMLContext context;
    private final XMLStreamReader streamReader;
    private final Deque<CityGMLChunk> chunks = new ArrayDeque<CityGMLChunk>();
    private final Deque<QName> features = new ArrayDeque<QName>();
    private final Map<QName, Map<QName, Boolean>> properties = new HashMap<QName, Map<QName, Boolean>>();
    private final Set<String> adeNamespaces;
    private CityGMLChunk current;
    private boolean hasNext = false;
    private int skipUntil = 0;

    public CityGMLChunkReader(XMLReader reader, ChunkOptions chunkOptions, IdCreator idCreator, XMLReaderFactory factory, CityGMLContext context) {
        super(reader);
        this.chunkOptions = chunkOptions;
        this.idCreator = idCreator;
        this.factory = factory;
        this.context = context;
        this.streamReader = reader.getStreamReader();
        this.adeNamespaces = ((CityGMLADELoader)ADERegistry.getInstance().getADELoader(CityGMLADELoader.class)).getADENamespaces();
    }

    @Override
    public boolean hasNext() throws CityGMLReadException {
        if (!this.hasNext) {
            try {
                XMLObjects xmlObjects = this.reader.getXMLObjects();
                boolean initialize = false;
                while (this.streamReader.hasNext()) {
                    int eventType = this.streamReader.next();
                    if (this.skipUntil == 0 && eventType == 1) {
                        ObjectBuilder builder = xmlObjects.getBuilder(this.reader.getName(), AbstractFeature.class);
                        if (builder != null) {
                            if (this.current == null) {
                                this.current = new CityGMLChunk(this.reader.getName(), this.factory, this.resolver);
                            } else if (this.shouldChunk(this.reader.getName())) {
                                this.chunks.push(this.current);
                                this.current = new CityGMLChunk(this.reader.getName(), this.factory, this.current, this.resolver);
                                initialize = true;
                            }
                            this.features.push(this.reader.getName());
                        }
                    } else if (eventType == 2) {
                        if (this.skipUntil > 0 && this.skipUntil == this.reader.getDepth() + 1) {
                            this.skipUntil = 0;
                        }
                        if (!this.features.isEmpty() && this.features.peek().equals(this.reader.getName())) {
                            this.features.pop();
                        }
                    }
                    if (this.current == null) continue;
                    this.current.bufferEvent(this.streamReader);
                    if (initialize) {
                        this.setXLink();
                        initialize = false;
                        continue;
                    }
                    if (!this.current.isComplete()) continue;
                    if (this.filter != null && !this.filter.accept(this.current.getFirstElement())) {
                        this.current = !this.chunks.isEmpty() ? this.chunks.pop() : null;
                        continue;
                    }
                    this.hasNext = !this.chunks.isEmpty() || !this.chunkOptions.isSkipCityModel() || !"CityModel".equals(this.current.getFirstElement().getLocalPart()) || !CityGMLModules.isCityGMLNamespace(this.current.getFirstElement().getNamespaceURI());
                    break;
                }
            }
            catch (XMLStreamException | SAXException | XMLReadException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
        }
        return this.hasNext;
    }

    @Override
    public AbstractFeature next() throws CityGMLReadException {
        if (this.hasNext()) {
            return this.nextChunk().build(true);
        }
        throw new NoSuchElementException();
    }

    @Override
    public CityGMLChunk nextChunk() throws CityGMLReadException {
        if (this.hasNext()) {
            try {
                CityGMLChunk next = this.current;
                CityGMLChunk cityGMLChunk = this.current = !this.chunks.isEmpty() ? this.chunks.pop() : null;
                if (this.transformer != null) {
                    next.transform(this.transformer);
                }
                CityGMLChunk cityGMLChunk2 = next;
                return cityGMLChunk2;
            }
            catch (TransformerException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
            finally {
                this.hasNext = false;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasParentInfo() {
        try {
            return this.getParentInfo() != null;
        }
        catch (CityGMLReadException e) {
            return false;
        }
    }

    @Override
    public FeatureInfo getParentInfo() throws CityGMLReadException {
        if (this.hasNext) {
            return !this.chunks.isEmpty() ? this.chunks.peek().getFeatureInfo() : null;
        }
        return this.current != null ? this.current.getFeatureInfo() : null;
    }

    @Override
    public void close() throws CityGMLReadException {
        try {
            super.close();
        }
        finally {
            this.current = null;
            this.chunks.clear();
            this.features.clear();
            this.properties.clear();
            this.adeNamespaces.clear();
        }
    }

    private boolean shouldChunk(QName feature) throws CityGMLReadException {
        QName property = this.current.getLastElement();
        if (!this.chunkOptions.shouldChunk(property)) {
            return false;
        }
        if (this.chunkOptions.isKeepInlineAppearance() && feature.getLocalPart().equals("Appearance") && CityGMLModules.isCityGMLNamespace(feature.getNamespaceURI()) && (!property.getLocalPart().equals("appearanceMember") || !CityGMLModules.isCityGMLNamespace(property.getNamespaceURI()))) {
            this.skipUntil = this.reader.getDepth();
            return false;
        }
        if (this.adeNamespaces.contains(property.getNamespaceURI())) {
            try {
                if (!this.properties.computeIfAbsent(this.features.peek(), v -> new HashMap()).computeIfAbsent(property, v -> this.hasXLink(property, this.features.peek())).booleanValue()) {
                    return false;
                }
            }
            catch (Throwable e) {
                throw new CityGMLReadException("Failed to parse XML schema definition of ADE " + property + ".", e);
            }
        }
        return !this.chunkOptions.isExcludeFeature(feature);
    }

    private void setXLink() {
        String gmlId = null;
        for (int i = 0; i < this.streamReader.getAttributeCount(); ++i) {
            if (!this.streamReader.getAttributeLocalName(i).equals("id")) continue;
            gmlId = this.streamReader.getAttributeValue(i);
            break;
        }
        if (gmlId == null) {
            gmlId = this.idCreator.createId();
            this.current.getSAXBuffer().addAttribute(GMLCoreModule.v3_1.getNamespaceURI(), "id", "gml:id", "CDATA", gmlId);
            this.current.getSAXBuffer().addAttribute(GMLCoreModule.v3_2.getNamespaceURI(), "id", "gml:id", "CDATA", gmlId);
        }
        this.chunks.getFirst().getSAXBuffer().removeTrailingCharacters();
        this.chunks.getFirst().getSAXBuffer().addAttribute(XLinkModule.v1_0.getNamespaceURI(), "href", "xlink:href", "CDATA", "#" + gmlId);
    }

    private boolean hasXLink(final QName property, QName feature) {
        try {
            XSElementDecl featureDecl;
            XSSchemaSet schemas;
            SchemaHandler schemaHandler = this.factory.getSchemaHandler() != null ? this.factory.getSchemaHandler() : this.context.getDefaultSchemaHandler();
            XSElementDecl propertyDecl = null;
            if (this.adeNamespaces.contains(feature.getNamespaceURI()) && (schemas = schemaHandler.getSchemaSet(feature.getNamespaceURI())) != null && (featureDecl = schemas.getElementDecl(feature.getNamespaceURI(), feature.getLocalPart())) != null) {
                final XSElementDecl[] localPropertyDecl = new XSElementDecl[1];
                featureDecl.getType().visit((XSVisitor)new SchemaWalker(){

                    public void elementDecl(XSElementDecl decl) {
                        if (decl.getName().equals(property.getLocalPart()) && decl.getTargetNamespace().equals(property.getNamespaceURI())) {
                            localPropertyDecl[0] = decl;
                            this.setShouldWalk(false);
                        }
                    }
                });
                propertyDecl = localPropertyDecl[0];
            }
            if (propertyDecl == null && (schemas = schemaHandler.getSchemaSet(property.getNamespaceURI())) != null) {
                propertyDecl = schemas.getElementDecl(property.getNamespaceURI(), property.getLocalPart());
            }
            if (propertyDecl != null) {
                final boolean[] hasXLink = new boolean[1];
                propertyDecl.getType().visit((XSVisitor)new SchemaWalker(){

                    public void attributeDecl(XSAttributeDecl decl) {
                        if (decl.getName().equals("href") && XLinkModule.v1_0.getNamespaceURI().equals(decl.getTargetNamespace())) {
                            hasXLink[0] = true;
                            this.setShouldWalk(false);
                        }
                    }

                    public void elementDecl(XSElementDecl decl) {
                    }
                });
                return hasXLink[0];
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

