/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.transform;

import java.util.Objects;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmlobjects.util.xml.SecureXMLProcessors;

public class TransformerPipeline {
    private final SAXTransformerFactory factory;
    private final Templates[] templates;
    private TransformerHandler[] handlers;

    private TransformerPipeline(SAXTransformerFactory factory, Templates[] templates) throws TransformerConfigurationException {
        this.factory = Objects.requireNonNull(factory, "SAX transformer factory must not be null.");
        this.templates = templates;
        this.buildPipeline();
    }

    public TransformerPipeline(TransformerPipeline other) throws TransformerConfigurationException {
        Objects.requireNonNull(other, "Transformation pipeline must not be null.");
        this.factory = other.factory;
        this.templates = other.templates;
        this.handlers = other.handlers;
        this.buildPipeline();
    }

    public static TransformerPipeline newInstance(SAXTransformerFactory factory, Templates ... templates) throws TransformerConfigurationException {
        if (templates == null || templates.length == 0) {
            throw new IllegalArgumentException("No transformation templates provided.");
        }
        return new TransformerPipeline(factory, templates);
    }

    public static TransformerPipeline newInstance(Templates ... templates) throws TransformerConfigurationException {
        return TransformerPipeline.newInstance((SAXTransformerFactory)SecureXMLProcessors.newTransformerFactory(), templates);
    }

    public static TransformerPipeline newInstance(SAXTransformerFactory factory, Source ... xsltSource) throws TransformerConfigurationException {
        Objects.requireNonNull(factory, "SAX transformer factory must not be null.");
        if (xsltSource == null || xsltSource.length == 0) {
            throw new IllegalArgumentException("No transformation sources provided.");
        }
        Templates[] templates = new Templates[xsltSource.length];
        for (int i = 0; i < xsltSource.length; ++i) {
            templates[i] = factory.newTemplates(xsltSource[i]);
        }
        return TransformerPipeline.newInstance(factory, templates);
    }

    public static TransformerPipeline newInstance(Source ... xsltSource) throws TransformerConfigurationException {
        return TransformerPipeline.newInstance((SAXTransformerFactory)SecureXMLProcessors.newTransformerFactory(), xsltSource);
    }

    public ContentHandler getRootHandler() {
        return this.handlers[0];
    }

    public void setResult(Result outputTarget) {
        this.handlers[this.handlers.length - 1].setResult(outputTarget);
    }

    public void transform(Source xmlSource, Result outputTarget, boolean isFragment) throws TransformerException {
        try {
            this.setResult(outputTarget);
            if (isFragment) {
                this.handlers[0].startDocument();
            }
            this.factory.newTransformer().transform(xmlSource, new SAXResult(this.handlers[0]));
            if (isFragment) {
                this.handlers[0].endDocument();
            }
        }
        catch (SAXException e) {
            throw new TransformerException("Caused by:", e);
        }
    }

    public void reset() throws TransformerException {
        this.buildPipeline();
    }

    public Object getParameter(String name) {
        return this.handlers[0].getTransformer().getParameter(name);
    }

    public void setParameter(String name, Object value) {
        for (TransformerHandler handler : this.handlers) {
            handler.getTransformer().setParameter(name, value);
        }
    }

    public String getOutputProperty(String name) {
        return this.handlers[0].getTransformer().getOutputProperty(name);
    }

    public void setOutputProperty(String name, String value) {
        for (TransformerHandler handler : this.handlers) {
            handler.getTransformer().setOutputProperty(name, value);
        }
    }

    public ErrorListener getErrorListener() {
        return this.handlers[0].getTransformer().getErrorListener();
    }

    public void setErrorListener(ErrorListener listener) {
        for (TransformerHandler handler : this.handlers) {
            handler.getTransformer().setErrorListener(listener);
        }
    }

    public URIResolver getURIResolver() {
        return this.handlers[0].getTransformer().getURIResolver();
    }

    public void setURIResolver(URIResolver resolver) {
        for (TransformerHandler handler : this.handlers) {
            handler.getTransformer().setURIResolver(resolver);
        }
    }

    private void buildPipeline() throws TransformerConfigurationException {
        this.handlers = new TransformerHandler[this.templates.length];
        for (int i = this.templates.length - 1; i >= 0; --i) {
            this.handlers[i] = this.factory.newTransformerHandler(this.templates[i]);
            if (i >= this.templates.length - 1) continue;
            this.handlers[i].setResult(new SAXResult(this.handlers[i + 1]));
        }
    }
}

