/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.writer;

import java.util.Objects;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXFragmentHandler
implements ContentHandler {
    private final ContentHandler parent;
    private final Mode mode;
    private boolean shouldHandle;
    private int depth;

    public SAXFragmentHandler(ContentHandler parent, Mode mode) {
        this.parent = Objects.requireNonNull(parent, "The parent handler must not be null.");
        this.mode = mode;
        this.shouldHandle = mode == Mode.HEADER;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.parent.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.shouldHandle) {
            this.parent.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.shouldHandle) {
            this.parent.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.shouldHandle) {
            this.parent.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.shouldHandle) {
            this.parent.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.shouldHandle) {
            this.parent.startElement(uri, localName, qName, atts);
        }
        if (this.depth++ == 0 && this.mode == Mode.FOOTER) {
            this.shouldHandle = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (--this.depth == 0 && this.mode == Mode.HEADER) {
            this.shouldHandle = false;
        }
        if (this.shouldHandle) {
            this.parent.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.shouldHandle) {
            this.parent.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.shouldHandle) {
            this.parent.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.shouldHandle) {
            this.parent.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.shouldHandle) {
            this.parent.skippedEntity(name);
        }
    }

    public static enum Mode {
        HEADER,
        FOOTER;

    }
}

