/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.appearance;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.appearance.RingReference;
import org.citygml4j.core.model.appearance.TexCoordList;
import org.citygml4j.core.model.appearance.TextureCoordinates;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.appearance.AbstractTextureParameterizationAdapter;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.annotation.XMLElements;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

@XMLElements(value={@XMLElement(name="TexCoordList", namespaceURI="http://www.opengis.net/citygml/appearance/3.0"), @XMLElement(name="TexCoordList", namespaceURI="http://www.opengis.net/citygml/appearance/2.0"), @XMLElement(name="TexCoordList", namespaceURI="http://www.opengis.net/citygml/appearance/1.0")})
public final class TexCoordListAdapter
extends AbstractTextureParameterizationAdapter<TexCoordList> {
    public TexCoordList createObject(QName name, Object parent) throws ObjectBuildException {
        return new TexCoordList();
    }

    @Override
    public void initializeObject(TexCoordList object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        LinkedHashMap<Integer, TextureCoordinates> result = new LinkedHashMap<Integer, TextureCoordinates>();
        int depth = reader.getDepth();
        int textureCoordinatesNo = 0;
        int ringNo = 0;
        while (reader.hasNext() && reader.getDepth() >= depth && reader.nextTag() == EventType.START_ELEMENT) {
            name = reader.getName();
            attributes = reader.getAttributes();
            if (!CityGMLBuilderHelper.isAppearanceNamespace(name.getNamespaceURI())) continue;
            switch (name.getLocalPart()) {
                case "textureCoordinates": {
                    TextureCoordinates textureCoordinates = result.computeIfAbsent(textureCoordinatesNo++, v -> new TextureCoordinates());
                    List value = reader.getTextContent().getAsDoubleList();
                    textureCoordinates.setValue(value != null ? value : new ArrayList());
                    if ("http://www.opengis.net/citygml/appearance/3.0".equals(name.getNamespaceURI())) break;
                    String ring = attributes.getValue("ring").get();
                    textureCoordinates.setRing(new RingReference(ring != null ? ring : ""));
                    ++ringNo;
                    break;
                }
                case "ring": {
                    TextureCoordinates textureCoordinates = result.computeIfAbsent(ringNo++, v -> new TextureCoordinates());
                    reader.getTextContent().ifPresent(v -> textureCoordinates.setRing(new RingReference(v)));
                }
            }
        }
        result.values().forEach(object.getTextureCoordinates()::add);
    }

    public Element createElement(TexCoordList object, Namespaces namespaces) throws ObjectSerializeException {
        return Element.of((String)CityGMLSerializerHelper.getAppearanceNamespace(namespaces), (String)"TexCoordList");
    }

    public void writeChildElements(TexCoordList object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        String appearanceNamespace = CityGMLSerializerHelper.getAppearanceNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/appearance/3.0".equals(appearanceNamespace);
        if (object.isSetTextureCoordinates()) {
            for (TextureCoordinates textureCoordinates : object.getTextureCoordinates()) {
                Element element = Element.of((String)appearanceNamespace, (String)"textureCoordinates").addTextContent(TextContent.ofDoubleList((List)textureCoordinates.getValue()));
                if (!isCityGML3) {
                    element.addAttribute("ring", this.getRing(textureCoordinates));
                }
                writer.writeElement(element);
            }
            if (isCityGML3) {
                for (TextureCoordinates textureCoordinates : object.getTextureCoordinates()) {
                    writer.writeElement(Element.of((String)appearanceNamespace, (String)"ring").addTextContent(this.getRing(textureCoordinates)));
                }
            }
        }
    }

    private String getRing(TextureCoordinates textureCoordinates) {
        return textureCoordinates.getRing() != null ? textureCoordinates.getRing().getHref() : null;
    }
}

