/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.construction;

import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractConstruction;
import org.citygml4j.core.model.construction.ADEOfAbstractConstruction;
import org.citygml4j.core.model.construction.AbstractConstruction;
import org.citygml4j.core.model.construction.ConditionOfConstructionValue;
import org.citygml4j.core.model.construction.ConstructionEventProperty;
import org.citygml4j.core.model.construction.ElevationProperty;
import org.citygml4j.core.model.construction.HeightProperty;
import org.citygml4j.core.model.core.OccupancyProperty;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.construction.ConstructionEventPropertyAdapter;
import org.citygml4j.xml.adapter.construction.ElevationPropertyAdapter;
import org.citygml4j.xml.adapter.construction.HeightPropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractOccupiedSpaceAdapter;
import org.citygml4j.xml.adapter.core.OccupancyPropertyAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractConstructionAdapter<T extends AbstractConstruction>
extends AbstractOccupiedSpaceAdapter<T> {
    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("http://www.opengis.net/citygml/construction/3.0".equals(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "conditionOfConstruction": {
                    reader.getTextContent().ifPresent(v -> object.setConditionOfConstruction(ConditionOfConstructionValue.fromValue((String)v)));
                    return;
                }
                case "dateOfConstruction": {
                    reader.getTextContent().ifDate(v -> object.setDateOfConstruction(v.toLocalDate()));
                    return;
                }
                case "dateOfDemolition": {
                    reader.getTextContent().ifDate(v -> object.setDateOfDemolition(v.toLocalDate()));
                    return;
                }
                case "constructionEvent": {
                    object.getConstructionEvents().add((ConstructionEventProperty)reader.getObjectUsingBuilder(ConstructionEventPropertyAdapter.class));
                    return;
                }
                case "elevation": {
                    object.getElevations().add((ElevationProperty)reader.getObjectUsingBuilder(ElevationPropertyAdapter.class));
                    return;
                }
                case "height": {
                    object.getHeights().add((HeightProperty)reader.getObjectUsingBuilder(HeightPropertyAdapter.class));
                    return;
                }
                case "occupancy": {
                    object.getOccupancies().add((OccupancyProperty)reader.getObjectUsingBuilder(OccupancyPropertyAdapter.class));
                    return;
                }
                case "adeOfAbstractConstruction": {
                    ADEBuilderHelper.addADEProperty(object, GenericADEOfAbstractConstruction::of, reader);
                    return;
                }
            }
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        if (namespaces.contains("http://www.opengis.net/citygml/construction/3.0")) {
            if (object.getConditionOfConstruction() != null) {
                writer.writeElement(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"conditionOfConstruction").addTextContent(object.getConditionOfConstruction().toValue()));
            }
            if (object.getDateOfConstruction() != null) {
                writer.writeElement(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"dateOfConstruction").addTextContent(TextContent.ofDate((OffsetDateTime)OffsetDateTime.of(object.getDateOfConstruction(), LocalTime.MIN, ZoneOffset.UTC))));
            }
            if (object.getDateOfDemolition() != null) {
                writer.writeElement(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"dateOfDemolition").addTextContent(TextContent.ofDate((OffsetDateTime)OffsetDateTime.of(object.getDateOfDemolition(), LocalTime.MIN, ZoneOffset.UTC))));
            }
            if (object.isSetConstructionEvents()) {
                for (ConstructionEventProperty property : object.getConstructionEvents()) {
                    writer.writeElementUsingSerializer(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"constructionEvent"), (Object)property, ConstructionEventPropertyAdapter.class, namespaces);
                }
            }
            if (object.isSetElevations()) {
                for (ConstructionEventProperty property : object.getElevations()) {
                    writer.writeElementUsingSerializer(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"elevation"), (Object)property, ElevationPropertyAdapter.class, namespaces);
                }
            }
            if (object.isSetHeights()) {
                for (ConstructionEventProperty property : object.getHeights()) {
                    writer.writeElementUsingSerializer(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"height"), (Object)property, HeightPropertyAdapter.class, namespaces);
                }
            }
            if (object.isSetOccupancies()) {
                for (ConstructionEventProperty property : object.getOccupancies()) {
                    writer.writeElementUsingSerializer(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"occupancy"), (Object)property, OccupancyPropertyAdapter.class, namespaces);
                }
            }
            for (ConstructionEventProperty property : object.getADEProperties(ADEOfAbstractConstruction.class)) {
                ADESerializerHelper.writeADEProperty(Element.of((String)"http://www.opengis.net/citygml/construction/3.0", (String)"adeOfAbstractConstruction"), (ADEProperty)property, namespaces, writer);
            }
        }
    }
}

