/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.core;

import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractCityObject;
import org.citygml4j.core.model.core.ADEOfAbstractCityObject;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractCityObjectProperty;
import org.citygml4j.core.model.core.AbstractCityObjectReference;
import org.citygml4j.core.model.core.AbstractDynamizerProperty;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.core.CityObjectRelationProperty;
import org.citygml4j.core.model.core.ExternalReference;
import org.citygml4j.core.model.core.ExternalReferenceProperty;
import org.citygml4j.core.model.core.RelativeToTerrain;
import org.citygml4j.core.model.core.RelativeToWater;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.core.AbstractAppearancePropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractCityObjectPropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractCityObjectReferenceAdapter;
import org.citygml4j.xml.adapter.core.AbstractDynamizerPropertyAdapter;
import org.citygml4j.xml.adapter.core.AbstractFeatureWithLifespanAdapter;
import org.citygml4j.xml.adapter.core.AbstractGenericAttributePropertyAdapter;
import org.citygml4j.xml.adapter.core.CityObjectRelationPropertyAdapter;
import org.citygml4j.xml.adapter.core.ExternalReferenceAdapter;
import org.citygml4j.xml.adapter.core.ExternalReferencePropertyAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.model.base.AssociationAttributes;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public abstract class AbstractCityObjectAdapter<T extends AbstractCityObject>
extends AbstractFeatureWithLifespanAdapter<T> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/2.0", "_GenericApplicationPropertyOfCityObject"), new QName("http://www.opengis.net/citygml/1.0", "_GenericApplicationPropertyOfCityObject")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isCoreNamespace(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "externalReference": {
                    if ("http://www.opengis.net/citygml/3.0".equals(name.getNamespaceURI())) {
                        object.getExternalReferences().add((ExternalReferenceProperty)reader.getObjectUsingBuilder(ExternalReferencePropertyAdapter.class));
                    } else {
                        ExternalReference reference = (ExternalReference)reader.getObjectUsingBuilder(ExternalReferenceAdapter.class);
                        object.getExternalReferences().add(new ExternalReferenceProperty(reference));
                    }
                    return;
                }
                case "generalizesTo": {
                    if ("http://www.opengis.net/citygml/3.0".equals(name.getNamespaceURI())) {
                        object.getGeneralizesTo().add((AbstractCityObjectReference)reader.getObjectUsingBuilder(AbstractCityObjectReferenceAdapter.class));
                    } else {
                        AbstractCityObjectProperty property = (AbstractCityObjectProperty)reader.getObjectUsingBuilder(AbstractCityObjectPropertyAdapter.class);
                        if (!property.isSetInlineObject() && !property.isSetGenericElement()) {
                            object.getGeneralizesTo().add(new AbstractCityObjectReference((AssociationAttributes)property));
                        } else {
                            object.getDeprecatedProperties().getGeneralizesTo().add(property);
                        }
                    }
                    return;
                }
                case "relativeToTerrain": {
                    reader.getTextContent().ifPresent(v -> object.setRelativeToTerrain(RelativeToTerrain.fromValue((String)v)));
                    return;
                }
                case "relativeToWater": {
                    reader.getTextContent().ifPresent(v -> object.setRelativeToWater(RelativeToWater.fromValue((String)v)));
                    return;
                }
                case "relatedTo": {
                    object.getRelatedTo().add((CityObjectRelationProperty)reader.getObjectUsingBuilder(CityObjectRelationPropertyAdapter.class));
                    return;
                }
                case "appearance": {
                    object.getAppearances().add((AbstractAppearanceProperty)reader.getObjectUsingBuilder(AbstractAppearancePropertyAdapter.class));
                    return;
                }
                case "genericAttribute": {
                    object.getGenericAttributes().add((AbstractGenericAttributeProperty)reader.getObjectUsingBuilder(AbstractGenericAttributePropertyAdapter.class));
                    return;
                }
                case "dynamizer": {
                    object.getDynamizers().add((AbstractDynamizerProperty)reader.getObjectUsingBuilder(AbstractDynamizerPropertyAdapter.class));
                    return;
                }
                case "adeOfAbstractCityObject": {
                    ADEBuilderHelper.addADEProperty(object, GenericADEOfAbstractCityObject::of, reader);
                    return;
                }
            }
        } else {
            if ("http://www.opengis.net/citygml/appearance/2.0".equals(name.getNamespaceURI()) || "http://www.opengis.net/citygml/appearance/1.0".equals(name.getNamespaceURI())) {
                object.getAppearances().add((AbstractAppearanceProperty)reader.getObjectUsingBuilder(AbstractAppearancePropertyAdapter.class));
                return;
            }
            if ("http://www.opengis.net/citygml/generics/2.0".equals(name.getNamespaceURI()) || "http://www.opengis.net/citygml/generics/1.0".equals(name.getNamespaceURI())) {
                object.getGenericAttributes().add(new AbstractGenericAttributeProperty((AbstractGenericAttribute)reader.getObject(AbstractGenericAttribute.class)));
                return;
            }
            if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
                this.buildADEProperty(object, name, reader);
                return;
            }
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractCityObject::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String coreNamespace = CityGMLSerializerHelper.getCoreNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/3.0".equals(coreNamespace);
        if (object.isSetExternalReferences()) {
            for (ExternalReferenceProperty property : object.getExternalReferences()) {
                if (isCityGML3) {
                    writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"externalReference"), (Object)property, ExternalReferencePropertyAdapter.class, namespaces);
                    continue;
                }
                writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"externalReference"), (Object)((ExternalReference)property.getObject()), ExternalReferenceAdapter.class, namespaces);
            }
        }
        if (object.isSetGeneralizesTo()) {
            for (AbstractCityObjectReference reference : object.getGeneralizesTo()) {
                writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"generalizesTo"), (Object)reference, AbstractCityObjectReferenceAdapter.class, namespaces);
            }
        }
        if (!isCityGML3 && object.hasDeprecatedProperties() && object.getDeprecatedProperties().isSetGeneralizesTo()) {
            for (ExternalReferenceProperty property : object.getDeprecatedProperties().getGeneralizesTo()) {
                writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"generalizesTo"), (Object)property, AbstractCityObjectPropertyAdapter.class, namespaces);
            }
        }
        if (object.getRelativeToTerrain() != null) {
            writer.writeElement(Element.of((String)coreNamespace, (String)"relativeToTerrain").addTextContent(object.getRelativeToTerrain().toValue()));
        }
        if (object.getRelativeToWater() != null) {
            writer.writeElement(Element.of((String)coreNamespace, (String)"relativeToWater").addTextContent(object.getRelativeToWater().toValue()));
        }
        if (isCityGML3 && object.isSetRelatedTo()) {
            for (ExternalReferenceProperty property : object.getRelatedTo()) {
                writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"relatedTo"), (Object)property, CityObjectRelationPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetAppearances()) {
            for (AbstractAppearanceProperty member : object.getAppearances()) {
                if (isCityGML3) {
                    writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"appearance"), (Object)member, AbstractAppearancePropertyAdapter.class, namespaces);
                    continue;
                }
                String namespace = namespaces.contains("http://www.opengis.net/citygml/appearance/1.0") ? "http://www.opengis.net/citygml/appearance/1.0" : "http://www.opengis.net/citygml/appearance/2.0";
                writer.writeElementUsingSerializer(Element.of((String)namespace, (String)"appearance"), (Object)member, AbstractAppearancePropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetGenericAttributes()) {
            for (ExternalReferenceProperty property : object.getGenericAttributes()) {
                if (isCityGML3) {
                    writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"genericAttribute"), (Object)property, AbstractGenericAttributePropertyAdapter.class, namespaces);
                    continue;
                }
                if (property.getObject() == null) continue;
                writer.writeObject((Object)property.getObject(), namespaces);
            }
        }
        if (isCityGML3 && object.isSetDynamizers()) {
            for (ExternalReferenceProperty property : object.getDynamizers()) {
                writer.writeElementUsingSerializer(Element.of((String)coreNamespace, (String)"dynamizer"), (Object)property, AbstractDynamizerPropertyAdapter.class, namespaces);
            }
        }
        for (ExternalReferenceProperty property : object.getADEProperties(ADEOfAbstractCityObject.class)) {
            ADESerializerHelper.writeADEProperty(isCityGML3 ? Element.of((String)coreNamespace, (String)"adeOfAbstractCityObject") : null, (ADEProperty)property, namespaces, writer);
        }
    }
}

