/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.deprecated.tunnel;

import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractTunnel;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.deprecated.tunnel.DeprecatedPropertiesOfAbstractTunnel;
import org.citygml4j.core.model.tunnel.ADEOfAbstractTunnel;
import org.citygml4j.core.model.tunnel.AbstractTunnel;
import org.citygml4j.core.model.tunnel.HollowSpaceProperty;
import org.citygml4j.core.model.tunnel.Tunnel;
import org.citygml4j.core.model.tunnel.TunnelInstallation;
import org.citygml4j.core.model.tunnel.TunnelInstallationProperty;
import org.citygml4j.core.model.tunnel.TunnelPartProperty;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.core.AbstractSpaceBoundaryPropertyAdapter;
import org.citygml4j.xml.adapter.deprecated.core.AbstractSiteAdapter;
import org.citygml4j.xml.adapter.deprecated.tunnel.AbstractBoundarySurfacePropertyAdapter;
import org.citygml4j.xml.adapter.tunnel.HollowSpacePropertyAdapter;
import org.citygml4j.xml.adapter.tunnel.TunnelInstallationPropertyAdapter;
import org.citygml4j.xml.adapter.tunnel.TunnelPartPropertyAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiCurvePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.aggregates.MultiSurfacePropertyAdapter;
import org.xmlobjects.gml.adapter.geometry.primitives.SolidPropertyAdapter;
import org.xmlobjects.gml.model.geometry.aggregates.MultiCurveProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurfaceProperty;
import org.xmlobjects.gml.model.geometry.primitives.SolidProperty;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractTunnelAdapter<T extends AbstractTunnel>
extends AbstractSiteAdapter<T> {
    private final QName substitutionGroup = new QName("http://www.opengis.net/citygml/tunnel/2.0", "_GenericApplicationPropertyOfAbstractTunnel");

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isTunnelNamespace(name.getNamespaceURI())) {
            if (CityGMLBuilderHelper.buildStandardObjectClassifier(object, name.getLocalPart(), reader)) {
                return;
            }
            switch (name.getLocalPart()) {
                case "yearOfConstruction": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfConstruction(v.toLocalDate()));
                    return;
                }
                case "yearOfDemolition": {
                    reader.getTextContent().ifGYear(v -> object.setDateOfDemolition(v.toLocalDate()));
                    return;
                }
                case "lod1Solid": {
                    object.setLod1Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod1MultiSurface": {
                    object.getDeprecatedProperties().setLod1MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod1TerrainIntersection": {
                    object.setLod1TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2Solid": {
                    object.setLod2Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod2MultiSurface": {
                    object.setLod2MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod2MultiCurve": {
                    object.setLod2MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod2TerrainIntersection": {
                    object.setLod2TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "outerTunnelInstallation": 
                case "interiorTunnelInstallation": {
                    object.getTunnelInstallations().add((TunnelInstallationProperty)reader.getObjectUsingBuilder(TunnelInstallationPropertyAdapter.class));
                    return;
                }
                case "boundedBy": {
                    object.addBoundary((AbstractSpaceBoundaryProperty)reader.getObjectUsingBuilder(AbstractSpaceBoundaryPropertyAdapter.class));
                    return;
                }
                case "lod3Solid": {
                    object.setLod3Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod3MultiSurface": {
                    object.setLod3MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod3MultiCurve": {
                    object.setLod3MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod3TerrainIntersection": {
                    object.setLod3TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4Solid": {
                    object.getDeprecatedProperties().setLod4Solid((SolidProperty)reader.getObjectUsingBuilder(SolidPropertyAdapter.class));
                    return;
                }
                case "lod4MultiSurface": {
                    object.getDeprecatedProperties().setLod4MultiSurface((MultiSurfaceProperty)reader.getObjectUsingBuilder(MultiSurfacePropertyAdapter.class));
                    return;
                }
                case "lod4MultiCurve": {
                    object.getDeprecatedProperties().setLod4MultiCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "lod4TerrainIntersection": {
                    object.getDeprecatedProperties().setLod4TerrainIntersectionCurve((MultiCurveProperty)reader.getObjectUsingBuilder(MultiCurvePropertyAdapter.class));
                    return;
                }
                case "interiorHollowSpace": {
                    object.getHollowSpaces().add((HollowSpaceProperty)reader.getObjectUsingBuilder(HollowSpacePropertyAdapter.class));
                    return;
                }
                case "consistsOfTunnelPart": {
                    TunnelPartProperty consistsOfTunnelPart = (TunnelPartProperty)reader.getObjectUsingBuilder(TunnelPartPropertyAdapter.class);
                    if ((consistsOfTunnelPart.getObject() != null || consistsOfTunnelPart.getGenericElement() != null) && object instanceof Tunnel) {
                        Tunnel tunnel = (Tunnel)object;
                        tunnel.getTunnelParts().add(consistsOfTunnelPart);
                    } else {
                        object.getDeprecatedProperties().getConsistsOfTunnelParts().add(consistsOfTunnelPart);
                    }
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractTunnel::of, reader, new QName[]{this.substitutionGroup})) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        Tunnel tunnel;
        super.writeChildElements(object, namespaces, writer);
        String tunnelNamespace = CityGMLSerializerHelper.getTunnelNamespace(namespaces);
        DeprecatedPropertiesOfAbstractTunnel properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        CityGMLSerializerHelper.writeStandardObjectClassifier(object, tunnelNamespace, namespaces, writer);
        if (object.getDateOfConstruction() != null) {
            writer.writeElement(Element.of((String)tunnelNamespace, (String)"yearOfConstruction").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfConstruction(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.getDateOfDemolition() != null) {
            writer.writeElement(Element.of((String)tunnelNamespace, (String)"yearOfDemolition").addTextContent(TextContent.ofGYear((OffsetDateTime)OffsetDateTime.of(object.getDateOfDemolition(), LocalTime.MIN, ZoneOffset.UTC))));
        }
        if (object.getLod1Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod1Solid"), (Object)object.getLod1Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod1MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod1MultiSurface"), (Object)properties.getLod1MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod1TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod1TerrainIntersection"), (Object)object.getLod1TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod2Solid"), (Object)object.getLod2Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod2MultiSurface"), (Object)object.getLod2MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod2MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod2MultiCurve"), (Object)object.getLod2MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod2TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod2TerrainIntersection"), (Object)object.getLod2TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetTunnelInstallations()) {
            for (Object property : object.getTunnelInstallations()) {
                if (property.getObject() != null && ((TunnelInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.INSIDE) {
                    writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"outerTunnelInstallation"), property, TunnelInstallationPropertyAdapter.class, namespaces);
                    continue;
                }
                writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"interiorTunnelInstallation"), property, TunnelInstallationPropertyAdapter.class, namespaces);
            }
        }
        if (object.isSetBoundaries()) {
            for (Object property : object.getBoundaries()) {
                writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"boundedBy"), property, AbstractBoundarySurfacePropertyAdapter.class, namespaces);
            }
        }
        if (object.getLod3Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod3Solid"), (Object)object.getLod3Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod3MultiSurface"), (Object)object.getLod3MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (object.getLod3MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod3MultiCurve"), (Object)object.getLod3MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.getLod3TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod3TerrainIntersection"), (Object)object.getLod3TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4Solid() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod4Solid"), (Object)properties.getLod4Solid(), SolidPropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiSurface() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod4MultiSurface"), (Object)properties.getLod4MultiSurface(), MultiSurfacePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4MultiCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod4MultiCurve"), (Object)properties.getLod4MultiCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (properties != null && properties.getLod4TerrainIntersectionCurve() != null) {
            writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"lod4TerrainIntersection"), (Object)properties.getLod4TerrainIntersectionCurve(), MultiCurvePropertyAdapter.class, namespaces);
        }
        if (object.isSetHollowSpaces()) {
            for (Object property : object.getHollowSpaces()) {
                writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"interiorHollowSpace"), property, HollowSpacePropertyAdapter.class, namespaces);
            }
        }
        if (object instanceof Tunnel && (tunnel = (Tunnel)object).isSetTunnelParts()) {
            for (TunnelPartProperty property : tunnel.getTunnelParts()) {
                writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"consistsOfTunnelPart"), (Object)property, TunnelPartPropertyAdapter.class, namespaces);
            }
        }
        if (properties != null && properties.isSetConsistsOfTunnelParts()) {
            for (Object property : properties.getConsistsOfTunnelParts()) {
                writer.writeElementUsingSerializer(Element.of((String)tunnelNamespace, (String)"consistsOfTunnelPart"), property, TunnelPartPropertyAdapter.class, namespaces);
            }
        }
        for (Object property : object.getADEProperties(ADEOfAbstractTunnel.class)) {
            ADESerializerHelper.writeADEProperty((ADEProperty)property, namespaces, writer);
        }
    }
}

