/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.adapter.relief;

import javax.xml.namespace.QName;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.ade.generic.GenericADEOfAbstractReliefComponent;
import org.citygml4j.core.model.relief.ADEOfAbstractReliefComponent;
import org.citygml4j.core.model.relief.AbstractReliefComponent;
import org.citygml4j.core.model.relief.ExtentProperty;
import org.citygml4j.xml.adapter.CityGMLBuilderHelper;
import org.citygml4j.xml.adapter.CityGMLSerializerHelper;
import org.citygml4j.xml.adapter.ade.ADEBuilderHelper;
import org.citygml4j.xml.adapter.ade.ADESerializerHelper;
import org.citygml4j.xml.adapter.core.AbstractSpaceBoundaryAdapter;
import org.citygml4j.xml.adapter.relief.ExtentPropertyAdapter;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public abstract class AbstractReliefComponentAdapter<T extends AbstractReliefComponent>
extends AbstractSpaceBoundaryAdapter<T> {
    private final QName[] substitutionGroups = new QName[]{new QName("http://www.opengis.net/citygml/relief/2.0", "_GenericApplicationPropertyOfReliefComponent"), new QName("http://www.opengis.net/citygml/relief/1.0", "_GenericApplicationPropertyOfReliefComponent")};

    @Override
    public void buildChildObject(T object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (CityGMLBuilderHelper.isReliefNamespace(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "lod": {
                    reader.getTextContent().ifInteger(arg_0 -> object.setLod(arg_0));
                    return;
                }
                case "extent": {
                    object.setExtent((ExtentProperty)reader.getObjectUsingBuilder(ExtentPropertyAdapter.class));
                    return;
                }
                case "adeOfAbstractReliefComponent": {
                    ADEBuilderHelper.addADEProperty(object, GenericADEOfAbstractReliefComponent::of, reader);
                    return;
                }
            }
        } else if (CityGMLBuilderHelper.isADENamespace(name.getNamespaceURI())) {
            this.buildADEProperty(object, name, reader);
            return;
        }
        super.buildChildObject(object, name, attributes, reader);
    }

    @Override
    public void buildADEProperty(T object, QName name, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if (!ADEBuilderHelper.addADEProperty(object, name, GenericADEOfAbstractReliefComponent::of, reader, this.substitutionGroups)) {
            super.buildADEProperty(object, name, reader);
        }
    }

    @Override
    public void writeChildElements(T object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.writeChildElements(object, namespaces, writer);
        String reliefNamespace = CityGMLSerializerHelper.getReliefNamespace(namespaces);
        boolean isCityGML3 = "http://www.opengis.net/citygml/relief/3.0".equals(reliefNamespace);
        writer.writeElement(Element.of((String)reliefNamespace, (String)"lod").addTextContent(TextContent.ofInteger((Integer)object.getLod())));
        if (object.getExtent() != null) {
            writer.writeElementUsingSerializer(Element.of((String)reliefNamespace, (String)"extent"), (Object)object.getExtent(), ExtentPropertyAdapter.class, namespaces);
        }
        for (ADEOfAbstractReliefComponent property : object.getADEProperties(ADEOfAbstractReliefComponent.class)) {
            ADESerializerHelper.writeADEProperty(isCityGML3 ? Element.of((String)reliefNamespace, (String)"adeOfAbstractReliefComponent") : null, (ADEProperty)property, namespaces, writer);
        }
    }
}

