/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.converter;

import java.util.List;
import java.util.regex.Pattern;
import org.xmlobjects.gml.model.geometry.DirectPositionList;
import org.xmlobjects.gml.model.geometry.compact.AbstractSimplePolygon;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.util.copy.CopyBuilder;

public abstract class AbstractSimplePolygonConverter<T extends AbstractSimplePolygonConverter<?>> {
    private final CopyBuilder builder = new CopyBuilder();
    private final Pattern pattern = Pattern.compile("[-_.\\p{L}0-9]+");
    private String idSuffix = this.getDefaultIdSuffix();

    AbstractSimplePolygonConverter() {
    }

    public T withIdSuffix(String idSuffix) {
        this.idSuffix = idSuffix != null && !idSuffix.isEmpty() && this.isValidIdSuffix(idSuffix) ? idSuffix : null;
        return (T)this;
    }

    public String getDefaultIdSuffix() {
        return "_0_";
    }

    public boolean isValidIdSuffix(String idSuffix) {
        return this.pattern.matcher(idSuffix).matches();
    }

    void copyProperties(AbstractSurface src, AbstractSurface dest) {
        this.builder.shallowCopy((Object)src, (Object)dest, AbstractSurface.class);
    }

    LinearRing getExteriorRing(AbstractSimplePolygon simplePolygon) {
        LinearRing linearRing = null;
        List coordinates = simplePolygon.getControlPoints().toCoordinateList3D();
        if (!coordinates.isEmpty()) {
            if (coordinates.size() > 8) {
                int size = coordinates.size();
                if (!(((Double)coordinates.get(0)).equals(coordinates.get(size - 3)) && ((Double)coordinates.get(1)).equals(coordinates.get(size - 2)) && ((Double)coordinates.get(2)).equals(coordinates.get(size - 1)))) {
                    coordinates.add((Double)coordinates.get(0));
                    coordinates.add((Double)coordinates.get(1));
                    coordinates.add((Double)coordinates.get(2));
                }
            }
            DirectPositionList posList = new DirectPositionList(coordinates);
            posList.setSrsDimension(Integer.valueOf(3));
            linearRing = new LinearRing(posList);
            if (this.idSuffix != null && simplePolygon.getId() != null) {
                linearRing.setId(simplePolygon.getId() + this.idSuffix);
            }
        }
        return linearRing;
    }
}

