/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.xml.module.citygml.CityGMLModules;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.citygml4j.xml.reader.FeatureInfo;
import org.citygml4j.xml.transform.TransformerPipeline;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.gml.model.common.LocalProperties;
import org.xmlobjects.gml.util.reference.ReferenceResolver;
import org.xmlobjects.gml.visitor.Visitable;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLReaderFactory;
import org.xmlobjects.util.xml.SAXBuffer;
import org.xmlobjects.util.xml.StAXStream2SAX;

public class CityGMLChunk {
    private final QName firstElement;
    private final XMLReaderFactory factory;
    private final CityGMLChunk parent;
    private final ReferenceResolver resolver;
    private FeatureInfo featureInfo;
    private SAXBuffer buffer;
    private StAXStream2SAX mapper;
    private QName lastElement;
    private int depth = 0;
    private LocalProperties localProperties;

    CityGMLChunk(QName firstElement, XMLReaderFactory factory, CityGMLChunk parent, ReferenceResolver resolver) {
        this.firstElement = this.lastElement = firstElement;
        this.factory = factory;
        this.parent = parent;
        this.resolver = resolver;
        this.buffer = new SAXBuffer().assumeMixedContent(false);
        this.mapper = new StAXStream2SAX((ContentHandler)this.buffer);
    }

    CityGMLChunk(QName firstElement, XMLReaderFactory factory, ReferenceResolver resolver) {
        this(firstElement, factory, null, resolver);
    }

    boolean isComplete() {
        return this.depth == 0 && !this.buffer.isEmpty();
    }

    void bufferEvent(XMLStreamReader reader) throws SAXException {
        int eventType = reader.getEventType();
        if (this.buffer.isEmpty() && eventType != 1) {
            throw new SAXException("A START_ELEMENT is expected as first element.");
        }
        if (this.isComplete() && (eventType == 1 || eventType == 2)) {
            throw new SAXException("Chunk is complete and cannot buffer more events.");
        }
        this.mapper.bridgeEvent(reader);
        switch (eventType) {
            case 1: {
                this.lastElement = reader.getName();
                ++this.depth;
                break;
            }
            case 2: {
                --this.depth;
            }
        }
    }

    SAXBuffer getSAXBuffer() {
        return this.buffer;
    }

    public QName getFirstElement() {
        return this.firstElement;
    }

    public QName getLastElement() {
        return this.lastElement;
    }

    void removeTrailingCharacters() {
        this.buffer.removeTrailingCharacters();
    }

    public XMLStreamReader toXMLStreamReader(boolean release) {
        return this.buffer.toXMLStreamReader(release);
    }

    public void send(ContentHandler handler, boolean release) throws SAXException {
        this.buffer.send(handler, release);
    }

    public AbstractFeature build(boolean release) throws CityGMLReadException {
        AbstractFeature abstractFeature;
        block9: {
            XMLReader reader = this.factory.createReader(this.buffer.toXMLStreamReader(release));
            try {
                reader.nextTag();
                AbstractFeature feature = (AbstractFeature)reader.getObject(AbstractFeature.class);
                if (feature != null && this.resolver != null) {
                    this.resolver.resolveReferences(new Visitable[]{feature});
                }
                abstractFeature = feature;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ObjectBuildException | XMLReadException e) {
                    throw new CityGMLReadException("Caused by:", e);
                }
            }
            reader.close();
        }
        return abstractFeature;
    }

    public AbstractFeature build() throws CityGMLReadException {
        return this.build(true);
    }

    FeatureInfo getFeatureInfo() throws CityGMLReadException {
        if (this.featureInfo == null) {
            try {
                FeatureInfoBuffer buffer = new FeatureInfoBuffer();
                this.send((ContentHandler)((Object)buffer), false);
                buffer.complete();
                try (XMLReader reader = this.factory.createReader(buffer.toXMLStreamReader(true));){
                    reader.nextTag();
                    AbstractFeature feature = (AbstractFeature)reader.getObject(AbstractFeature.class);
                    if (feature != null) {
                        this.featureInfo = new FeatureInfo(this.firstElement, feature, this.parent);
                    }
                }
            }
            catch (SAXException | ObjectBuildException | XMLReadException e) {
                throw new CityGMLReadException("Caused by:", e);
            }
        }
        return this.featureInfo;
    }

    void transform(TransformerPipeline pipeline) throws TransformerException {
        try {
            SAXBuffer buffer = new TransformerBuffer().assumeMixedContent(false);
            pipeline.setResult(new SAXResult((ContentHandler)buffer));
            pipeline.getRootHandler().startDocument();
            this.send(pipeline.getRootHandler(), true);
            pipeline.getRootHandler().endDocument();
            this.buffer = buffer;
            this.mapper = new StAXStream2SAX((ContentHandler)buffer);
        }
        catch (SAXException e) {
            throw new TransformerException("Caused by:", e);
        }
        finally {
            pipeline.reset();
        }
    }

    public boolean hasLocalProperties() {
        return this.localProperties != null && !this.localProperties.isEmpty();
    }

    public LocalProperties getLocalProperties() {
        if (this.localProperties == null) {
            this.localProperties = new LocalProperties();
        }
        return this.localProperties;
    }

    public void setLocalProperties(LocalProperties localProperties) {
        this.localProperties = localProperties;
    }

    private static class FeatureInfoBuffer
    extends SAXBuffer {
        int depth = 0;
        boolean shouldBuffer = true;

        private FeatureInfoBuffer() {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.shouldBuffer) {
                super.startPrefixMapping(prefix, uri);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.depth == 1) {
                boolean bl = this.shouldBuffer = CityGMLModules.isGMLNamespace(uri) && ("description".equals(localName) || "descriptionReference".equals(localName) || "identifier".equals(localName) || "name".equals(localName) || "metaDataProperty".equals(localName) || "boundedBy".equals(localName)) || CityGMLModules.isCityGMLNamespace(uri) && ("engineeringCRS".equals(localName) || "appearance".equals(localName) || "appearanceMember".equals(localName));
            }
            if (this.shouldBuffer) {
                super.startElement(uri, localName, qName, attributes);
            }
            ++this.depth;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.shouldBuffer) {
                super.endElement(uri, localName, qName);
            }
            --this.depth;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.shouldBuffer) {
                super.characters(ch, start, length);
            }
        }

        void complete() {
            while (this.depth-- >= 0) {
                this.addEndElement();
            }
        }
    }

    private static class TransformerBuffer
    extends SAXBuffer {
        private TransformerBuffer() {
        }

        public void startDocument() {
        }

        public void addEndDocument() {
        }
    }
}

