/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.reader;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.CityModel;
import org.citygml4j.core.model.core.EngineeringCRSProperty;
import org.citygml4j.xml.reader.CityGMLChunk;
import org.citygml4j.xml.reader.CityGMLReadException;
import org.xmlobjects.gml.model.base.Reference;
import org.xmlobjects.gml.model.basictypes.Code;
import org.xmlobjects.gml.model.basictypes.CodeWithAuthority;
import org.xmlobjects.gml.model.deprecated.MetaDataProperty;
import org.xmlobjects.gml.model.deprecated.StringOrRef;
import org.xmlobjects.gml.model.feature.BoundingShape;

public class FeatureInfo {
    private final QName name;
    private final AbstractFeature feature;
    private final CityGMLChunk parent;

    FeatureInfo(QName name, AbstractFeature feature, CityGMLChunk parent) {
        this.name = name;
        this.feature = feature;
        this.parent = parent;
    }

    public QName getTypeName() {
        return this.name;
    }

    public Class<? extends AbstractFeature> getType() {
        return this.feature.getClass();
    }

    public AbstractFeature getBackingFeature() {
        return this.feature;
    }

    public boolean hasParentInfo() {
        try {
            return this.getParentInfo() != null;
        }
        catch (CityGMLReadException e) {
            return false;
        }
    }

    public FeatureInfo getParentInfo() throws CityGMLReadException {
        return this.parent != null ? this.parent.getFeatureInfo() : null;
    }

    public String getId() {
        return this.feature.getId();
    }

    public List<MetaDataProperty<?>> getMetaDataProperties() {
        return this.feature.getMetaDataProperties();
    }

    public boolean isSetMetaDataProperties() {
        return this.feature.isSetMetaDataProperties();
    }

    public StringOrRef getDescription() {
        return this.feature.getDescription();
    }

    public Reference getDescriptionReference() {
        return this.feature.getDescriptionReference();
    }

    public CodeWithAuthority getIdentifier() {
        return this.feature.getIdentifier();
    }

    public List<Code> getNames() {
        return this.feature.getNames();
    }

    public boolean isSetNames() {
        return this.feature.isSetNames();
    }

    public BoundingShape getBoundedBy() {
        return this.feature.getBoundedBy();
    }

    public EngineeringCRSProperty getEngineeringCRS() {
        EngineeringCRSProperty engineeringCRSProperty;
        AbstractFeature abstractFeature = this.feature;
        if (abstractFeature instanceof CityModel) {
            CityModel cityModel = (CityModel)abstractFeature;
            engineeringCRSProperty = cityModel.getEngineeringCRS();
        } else {
            engineeringCRSProperty = null;
        }
        return engineeringCRSProperty;
    }

    public List<AbstractAppearanceProperty> getAppearances() {
        AbstractFeature abstractFeature = this.feature;
        if (abstractFeature instanceof AbstractCityObject) {
            AbstractCityObject cityObject = (AbstractCityObject)abstractFeature;
            return cityObject.getAppearances();
        }
        abstractFeature = this.feature;
        if (abstractFeature instanceof CityModel) {
            CityModel cityModel = (CityModel)abstractFeature;
            return cityModel.getAppearanceMembers();
        }
        return Collections.emptyList();
    }

    public boolean isSetAppearances() {
        AbstractFeature abstractFeature = this.feature;
        if (abstractFeature instanceof AbstractCityObject) {
            AbstractCityObject cityObject = (AbstractCityObject)abstractFeature;
            return cityObject.isSetAppearances();
        }
        abstractFeature = this.feature;
        if (abstractFeature instanceof CityModel) {
            CityModel cityModel = (CityModel)abstractFeature;
            return cityModel.isSetAppearanceMembers();
        }
        return false;
    }
}

