/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.writer;

import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.xml.module.Module;
import org.citygml4j.xml.module.ade.ADEModule;
import org.citygml4j.xml.module.citygml.CityGMLModule;
import org.citygml4j.xml.module.citygml.CityGMLModules;
import org.citygml4j.xml.module.citygml.CoreModule;
import org.citygml4j.xml.module.gml.GMLCompactEncodingModule;
import org.citygml4j.xml.module.gml.GMLExtendedBaseTypesModule;
import org.citygml4j.xml.transform.TransformerPipeline;
import org.citygml4j.xml.writer.CityGMLWriteException;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.stream.XMLWriterFactory;
import org.xmlobjects.xml.Namespaces;

public abstract class AbstractCityGMLWriter<T extends AbstractCityGMLWriter<?>>
implements AutoCloseable {
    final XMLWriter writer;
    final CityGMLVersion version;
    final XMLWriterFactory factory;
    final Namespaces namespaces;
    TransformerPipeline transformer;

    AbstractCityGMLWriter(XMLWriter writer, CityGMLVersion version, XMLWriterFactory factory) {
        this.writer = writer;
        this.version = version;
        this.factory = factory;
        this.namespaces = Namespaces.newInstance();
        for (Module module : CityGMLModules.of(version).getModules()) {
            this.namespaces.add(module.getNamespaceURI());
        }
        if (version == CityGMLVersion.v3_0) {
            this.namespaces.add(GMLCompactEncodingModule.v3_3.getNamespaceURI()).add(GMLExtendedBaseTypesModule.v3_3.getNamespaceURI());
        }
    }

    public String getPrefix(String namespaceURI) {
        return this.writer.getPrefix(namespaceURI);
    }

    public T withPrefix(String prefix, String namespaceURI) {
        this.writer.withPrefix(prefix, namespaceURI);
        return (T)this;
    }

    public T withDefaultPrefixes() {
        for (Module module : CityGMLModules.of(this.version).getModules()) {
            this.withPrefix(module.getNamespacePrefix(), module.getNamespaceURI());
        }
        return (T)this;
    }

    public String getNamespaceURI(String prefix) {
        return this.writer.getNamespaceURI(prefix);
    }

    public T withDefaultNamespace(String namespaceURI) {
        this.writer.withDefaultNamespace(namespaceURI);
        return (T)this;
    }

    public String getIndent() {
        return this.writer.getIndent();
    }

    public T withIndent(String indent) {
        this.writer.withIndent(indent);
        return (T)this;
    }

    public boolean isWriteXMLDeclaration() {
        return this.writer.isWriteXMLDeclaration();
    }

    public T writeXMLDeclaration(boolean writeXMLDeclaration) {
        this.writer.writeXMLDeclaration(writeXMLDeclaration);
        return (T)this;
    }

    public String[] getHeaderComment() {
        return this.writer.getHeaderComment();
    }

    public T withHeaderComment(String ... headerComment) {
        this.writer.withHeaderComment(headerComment);
        return (T)this;
    }

    public String getSchemaLocation(String namespaceURI) {
        return this.writer.getSchemaLocation(namespaceURI);
    }

    public T withSchemaLocation(String namespaceURI, String schemaLocation) {
        this.writer.withSchemaLocation(namespaceURI, schemaLocation);
        return (T)this;
    }

    public T withDefaultSchemaLocations() {
        for (Module module : CityGMLModules.of(this.version).getModules()) {
            if (!module.isSetSchemaLocation() || (!(module instanceof CityGMLModule) || module instanceof CoreModule) && !(module instanceof ADEModule)) continue;
            this.writer.withSchemaLocation(module.getNamespaceURI(), module.getSchemaLocation());
        }
        return (T)this;
    }

    public void flush() throws CityGMLWriteException {
        try {
            this.writer.flush();
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    @Override
    public void close() throws CityGMLWriteException {
        try {
            this.writer.close();
        }
        catch (XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }
}

