/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml.writer;

import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.core.model.CityGMLVersion;
import org.citygml4j.core.model.core.AbstractAppearance;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractVersion;
import org.citygml4j.core.model.core.AbstractVersionTransition;
import org.citygml4j.core.model.core.CityModel;
import org.citygml4j.xml.module.citygml.AppearanceModule;
import org.citygml4j.xml.module.citygml.CoreModule;
import org.citygml4j.xml.module.gml.GMLCoreModule;
import org.citygml4j.xml.reader.FeatureInfo;
import org.citygml4j.xml.writer.AbstractCityGMLWriter;
import org.citygml4j.xml.writer.CityGMLWriteException;
import org.citygml4j.xml.writer.CityModelInfo;
import org.citygml4j.xml.writer.SAXFragmentHandler;
import org.xml.sax.ContentHandler;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.stream.XMLWriterFactory;
import org.xmlobjects.util.copy.CopyBuilder;
import org.xmlobjects.xml.Element;

public class CityGMLChunkWriter
extends AbstractCityGMLWriter<CityGMLChunkWriter> {
    private CityModelInfo cityModelInfo;
    private State state = State.INITIAL;

    public CityGMLChunkWriter(XMLWriter writer, CityGMLVersion version, XMLWriterFactory factory) {
        super(writer, version, factory);
    }

    public CityModelInfo getCityModelInfo() {
        if (this.cityModelInfo == null) {
            this.cityModelInfo = new CityModelInfo();
        }
        return this.cityModelInfo;
    }

    public CityGMLChunkWriter withCityModelInfo(CityModel cityModel) {
        if (cityModel != null) {
            this.cityModelInfo = new CityModelInfo(cityModel);
        }
        return this;
    }

    public CityGMLChunkWriter withCityModelInfo(FeatureInfo featureInfo) {
        if (featureInfo != null) {
            this.cityModelInfo = new CityModelInfo();
            this.cityModelInfo.setId(featureInfo.getId());
            this.cityModelInfo.setDescription(featureInfo.getDescription());
            this.cityModelInfo.setDescriptionReference(featureInfo.getDescriptionReference());
            this.cityModelInfo.setIdentifier(featureInfo.getIdentifier());
            this.cityModelInfo.setBoundedBy(featureInfo.getBoundedBy());
            this.cityModelInfo.setEngineeringCRS(featureInfo.getEngineeringCRS());
            if (featureInfo.isSetMetaDataProperties()) {
                this.cityModelInfo.setMetaDataProperties(featureInfo.getMetaDataProperties());
            }
            if (featureInfo.isSetNames()) {
                this.cityModelInfo.setNames(featureInfo.getNames());
            }
        }
        return this;
    }

    public void writeMember(AbstractFeature feature) throws CityGMLWriteException {
        if (feature instanceof AbstractCityObject) {
            this.writeMember(feature, CoreModule.of(this.version).getNamespaceURI(), "cityObjectMember");
        } else if (feature instanceof AbstractAppearance) {
            this.writeMember(feature, this.version != CityGMLVersion.v3_0 ? AppearanceModule.of(this.version).getNamespaceURI() : CoreModule.of(this.version).getNamespaceURI(), "appearanceMember");
        } else if (this.version == CityGMLVersion.v3_0) {
            if (feature instanceof AbstractVersion) {
                this.writeMember(feature, CoreModule.v3_0.getNamespaceURI(), "versionMember");
            } else if (feature instanceof AbstractVersionTransition) {
                this.writeMember(feature, CoreModule.v3_0.getNamespaceURI(), "versionTransitionMember");
            } else {
                this.writeMember(feature, CoreModule.v3_0.getNamespaceURI(), "featureMember");
            }
        } else {
            this.writeMember(feature, GMLCoreModule.v3_1.getNamespaceURI(), "featureMember");
        }
    }

    private void writeMember(AbstractFeature feature, String namespaceURI, String propertyName) throws CityGMLWriteException {
        switch (this.state) {
            case CLOSED: {
                throw new CityGMLWriteException("Illegal to write features after writer has been closed.");
            }
            case INITIAL: {
                this.writeHeader();
            }
        }
        try {
            XMLWriter writer = this.getWriter(this.writer.getContentHandler(true));
            writer.writeStartDocument();
            writer.writeStartElement(Element.of((String)namespaceURI, (String)propertyName));
            writer.writeObject((Object)feature, this.namespaces);
            writer.writeEndElement();
            writer.writeEndDocument();
            this.resetTransformer();
        }
        catch (TransformerException | ObjectSerializeException | XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    private void writeHeader() throws CityGMLWriteException {
        if (this.state != State.INITIAL) {
            throw new CityGMLWriteException("The document has already been started.");
        }
        try {
            CityModel cityModel;
            if (this.cityModelInfo != null) {
                cityModel = (CityModel)this.cityModelInfo.getCityModel().shallowCopy(new CopyBuilder());
                cityModel.setADEProperties(null);
            } else {
                cityModel = new CityModel();
            }
            SAXFragmentHandler fragmentHandler = new SAXFragmentHandler(this.writer.getContentHandler(), SAXFragmentHandler.Mode.HEADER);
            XMLWriter writer = this.getWriter(fragmentHandler);
            writer.writeStartDocument();
            writer.writeObject((Object)cityModel, this.namespaces);
            writer.writeEndDocument();
            this.resetTransformer();
        }
        catch (TransformerException | ObjectSerializeException | XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
        finally {
            this.state = State.DOCUMENT_STARTED;
        }
    }

    private void writeFooter() throws CityGMLWriteException {
        if (this.state == State.INITIAL) {
            this.writeHeader();
        }
        try {
            CityModel cityModel = new CityModel();
            if (this.cityModelInfo != null) {
                cityModel.setADEProperties(this.cityModelInfo.getADEProperties());
            }
            SAXFragmentHandler fragmentHandler = new SAXFragmentHandler(this.writer.getContentHandler(), SAXFragmentHandler.Mode.FOOTER);
            XMLWriter writer = this.getWriter(fragmentHandler);
            writer.writeStartDocument();
            writer.writeObject((Object)cityModel, this.namespaces);
            writer.writeEndDocument();
        }
        catch (ObjectSerializeException | XMLWriteException e) {
            throw new CityGMLWriteException("Caused by:", e);
        }
    }

    private XMLWriter getWriter(ContentHandler handler) {
        if (this.transformer == null) {
            return this.factory.createWriter(handler);
        }
        XMLWriter writer = this.factory.createWriter(this.transformer.getRootHandler());
        this.transformer.setResult(new SAXResult(handler));
        return writer;
    }

    private void resetTransformer() throws TransformerException {
        if (this.transformer != null) {
            this.transformer.reset();
        }
    }

    @Override
    public void close() throws CityGMLWriteException {
        if (this.state == State.CLOSED) {
            throw new CityGMLWriteException("The writer has already been closed.");
        }
        try {
            this.writeFooter();
            super.close();
        }
        finally {
            this.state = State.CLOSED;
        }
    }

    private static enum State {
        INITIAL,
        DOCUMENT_STARTED,
        CLOSED;

    }
}

