/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.avsl.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.clapper.avsl.AVSLConfigException;
import org.clapper.avsl.LogLevel;
import org.clapper.avsl.LogMessage;
import org.clapper.avsl.config.ConfiguredArguments;
import org.clapper.avsl.formatter.Formatter;
import org.clapper.avsl.handler.Handler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001-\u0011A\"R7bS2D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000f!\fg\u000e\u001a7fe*\u0011QAB\u0001\u0005CZ\u001cHN\u0003\u0002\b\u0011\u000591\r\\1qa\u0016\u0014(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011q\u0001S1oI2,'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003\u0011\t'oZ:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011AB2p]\u001aLw-\u0003\u0002\u001e5\t\u00192i\u001c8gS\u001e,(/\u001a3Be\u001e,X.\u001a8ug\"Aq\u0004\u0001BC\u0002\u0013\u0005\u0001%A\u0005g_Jl\u0017\r\u001e;feV\t\u0011\u0005\u0005\u0002#I5\t1E\u0003\u0002 \t%\u0011Qe\t\u0002\n\r>\u0014X.\u0019;uKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006I!I\u0001\u000bM>\u0014X.\u0019;uKJ\u0004\u0003\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\u000b1,g/\u001a7\u0016\u0003-\u0002\"\u0001L\u0017\u000e\u0003\u0011I!A\f\u0003\u0003\u00111{w\rT3wK2D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0007Y\u00164X\r\u001c\u0011\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0011!TGN\u001c\u0011\u0005M\u0001\u0001\"B\f2\u0001\u0004A\u0002\"B\u00102\u0001\u0004\t\u0003\"B\u00152\u0001\u0004Y\u0003bB\u001d\u0001\u0005\u0004%\tAO\u0001\u0007g\u0016tG-\u001a:\u0016\u0003m\u0002\"\u0001P\"\u000e\u0003uR!AP \u0002\u0011%tG/\u001a:oKRT!\u0001Q!\u0002\t5\f\u0017\u000e\u001c\u0006\u0002\u0005\u0006)!.\u0019<bq&\u0011A)\u0010\u0002\u0010\u0013:$XM\u001d8fi\u0006#GM]3tg\"1a\t\u0001Q\u0001\nm\nqa]3oI\u0016\u0014\b\u0005C\u0004I\u0001\t\u0007I\u0011A%\u0002\u0015I,7-\u001b9jK:$8/F\u0001K!\ri1*T\u0005\u0003\u0019:\u0011Q!\u0011:sCf\u0004\"AT(\u000e\u0003}J!\u0001U \u0003\u000f\u0005#GM]3tg\"1!\u000b\u0001Q\u0001\n)\u000b1B]3dSBLWM\u001c;tA!9A\u000b\u0001b\u0001\n\u0003)\u0016AC:niB\u001cVM\u001d<feV\ta\u000b\u0005\u0002X5:\u0011Q\u0002W\u0005\u00033:\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011L\u0004\u0005\u0007=\u0002\u0001\u000b\u0011\u0002,\u0002\u0017MlG\u000f]*feZ,'\u000f\t\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0003!\u0019X\u000e\u001e9Q_J$X#\u00012\u0011\u00075\u0019W-\u0003\u0002e\u001d\t1q\n\u001d;j_:\u0004\"!\u00044\n\u0005\u001dt!aA%oi\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0011b]7uaB{'\u000f\u001e\u0011\t\u000f-\u0004!\u0019!C\u0001+\u000691/\u001e2kK\u000e$\bBB7\u0001A\u0003%a+\u0001\u0005tk\nTWm\u0019;!\u0011!y\u0007\u0001#b\u0001\n\u0013\u0001\u0018!\u00029s_B\u001cX#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\nQ\u0001K]8qKJ$\u0018.Z:\t\u0011i\u0004\u0001\u0012!Q!\nE\fa\u0001\u001d:paN\u0004\u0003\u0002\u0003?\u0001\u0011\u000b\u0007I\u0011B?\u0002\u000fM,7o]5p]V\ta\u0010\u0005\u0002O\u007f&\u0019\u0011\u0011A \u0003\u000fM+7o]5p]\"I\u0011Q\u0001\u0001\t\u0002\u0003\u0006KA`\u0001\tg\u0016\u001c8/[8oA!Q\u0011\u0011\u0002\u0001\t\u0006\u0004%I!a\u0003\u0002\u0013Q\u0014\u0018M\\:q_J$XCAA\u0007!\rq\u0015qB\u0005\u0004\u0003#y$!\u0003+sC:\u001c\bo\u001c:u\u0011)\t)\u0002\u0001E\u0001B\u0003&\u0011QB\u0001\u000biJ\fgn\u001d9peR\u0004cABA\r\u0001\u0011\tYB\u0001\tTiJLgn\u001a#bi\u0006\u001cv.\u001e:dKN1\u0011qCA\u000f\u0003S\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G)\u0018\u0001\u00027b]\u001eLA!a\n\u0002\"\t1qJ\u00196fGR\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\t\u0015AC1di&4\u0018\r^5p]&!\u00111GA\u0017\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\u000b\u0003o\t9B!A!\u0002\u00131\u0016!A:\t\u000fI\n9\u0002\"\u0001\u0002<Q!\u0011QHA!!\u0011\ty$a\u0006\u000e\u0003\u0001Aq!a\u000e\u0002:\u0001\u0007a\u000b\u0003\u0006\u0002F\u0005]!\u0019!C\u0001\u0003\u000f\n1bY8oi\u0016tG\u000fV=qKV\u0011\u0011\u0011\n\t\u0005\u0003?\tY%C\u0002\\\u0003CA\u0011\"a\u0014\u0002\u0018\u0001\u0006I!!\u0013\u0002\u0019\r|g\u000e^3oiRK\b/\u001a\u0011\t\u0011\u0005M\u0013q\u0003C\u0001\u0003+\nabZ3u\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^U\f!![8\n\t\u0005\u0005\u00141\f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002f\u0005]A\u0011AA4\u0003=9W\r^(viB,Ho\u0015;sK\u0006lGCAA5!\u0011\tI&a\u001b\n\t\u00055\u00141\f\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003c\n9\u0002\"\u0001\u0002t\u0005qq-\u001a;D_:$XM\u001c;UsB,GCAA%\u0011!\t9(a\u0006\u0005\u0002\u0005M\u0014aB4fi:\u000bW.\u001a\u0005\b\u0003w\u0002A\u0011AA?\u0003\rawn\u001a\u000b\u0007\u0003\u007f\n))!#\u0011\u00075\t\t)C\u0002\u0002\u0004:\u0011A!\u00168ji\"9\u0011qQA=\u0001\u00041\u0016aB7fgN\fw-\u001a\u0005\t\u0003\u0017\u000bI\b1\u0001\u0002\u000e\u0006QAn\\4NKN\u001c\u0018mZ3\u0011\u00071\ny)C\u0002\u0002\u0012\u0012\u0011!\u0002T8h\u001b\u0016\u001c8/Y4f\u0001")
public class EmailHandler
implements Handler {
    private final Formatter formatter;
    private final LogLevel level;
    private final InternetAddress sender;
    private final Address[] recipients;
    private final String smtpServer;
    private final Option<Object> smtpPort;
    private final String subject;
    private Properties props;
    private Session session;
    private Transport transport;
    private volatile byte bitmap$0;

    private Properties props$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.props = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.props;
        }
    }

    private Session session$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = Session.getDefaultInstance((Properties)this.props(), null);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.session;
        }
    }

    private Transport transport$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.transport = this.session().getTransport("smtp");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.transport;
        }
    }

    @Override
    public Formatter formatter() {
        return this.formatter;
    }

    @Override
    public LogLevel level() {
        return this.level;
    }

    public InternetAddress sender() {
        return this.sender;
    }

    public Address[] recipients() {
        return this.recipients;
    }

    public String smtpServer() {
        return this.smtpServer;
    }

    public Option<Object> smtpPort() {
        return this.smtpPort;
    }

    public String subject() {
        return this.subject;
    }

    private Properties props() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.props$lzycompute() : this.props;
    }

    private Session session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    private Transport transport() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.transport$lzycompute() : this.transport;
    }

    @Override
    public void log(String message, LogMessage logMessage) {
        MimeMessage mailMessage = new MimeMessage(this.session());
        MimeMultipart body = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler((DataSource)new StringDataSource(this, message)));
        body.addBodyPart((BodyPart)bodyPart);
        mailMessage.setSender((Address)this.sender());
        mailMessage.setFrom((Address)this.sender());
        mailMessage.setRecipients(Message.RecipientType.TO, this.recipients());
        mailMessage.setSubject(this.subject().replaceAll("%l", logMessage.level().label()));
        mailMessage.setContent((Multipart)body);
        mailMessage.addHeaderLine(new StringBuilder().append((Object)"X-Mailer: ").append((Object)this.getClass().getName()).toString());
        mailMessage.setSentDate(new Date());
        this.transport().connect();
        Transport.send((Message)mailMessage);
        this.transport().close();
    }

    public EmailHandler(ConfiguredArguments args, Formatter formatter, LogLevel level2) {
        this.formatter = formatter;
        this.level = level2;
        this.sender = (InternetAddress)args.get("sender").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternetAddress apply(String x$1) {
                return new InternetAddress(x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new AVSLConfigException("Missing 'sender' for EmailHandler.");
            }
        });
        this.recipients = (Address[])args.get("recipients").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Address[] apply(String x$2) {
                return (Address[])Predef$.MODULE$.refArrayOps((Object[])InternetAddress.parse((String)x$2, (boolean)true)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Address apply(InternetAddress x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Address.class)));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new AVSLConfigException("No recipients specified for email handler.");
            }
        });
        this.smtpServer = args.getOrElse("smtp.server", "localhost");
        this.smtpPort = args.get("smtp.port").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String sPort) {
                return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)new Serializable(this, sPort){
                    public static final long serialVersionUID = 0L;
                    private final String sPort$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.sPort$1)).toInt();
                    }
                    {
                        this.sPort$1 = sPort$1;
                    }
                }).recover((PartialFunction)new Serializable(this, sPort){
                    public static final long serialVersionUID = 0L;
                    private final String sPort$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof NumberFormatException) {
                            throw new AVSLConfigException(new StringBuilder().append((Object)"Bad SMTP port: ").append((Object)this.sPort$1).toString());
                        }
                        Object object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof NumberFormatException;
                        return bl;
                    }
                    {
                        this.sPort$1 = sPort$1;
                    }
                }).get());
            }
        });
        this.subject = args.getOrElse("subject", "%l message");
        this.props().put("mail.smtp.host", this.smtpServer());
        this.props().put("mail.smtp.allow8bitmime", "true");
    }

    public class StringDataSource
    implements DataSource {
        private final String s;
        private final String contentType;
        public final /* synthetic */ EmailHandler $outer;

        public String contentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.s.getBytes());
        }

        public OutputStream getOutputStream() {
            throw new IOException("OutputStream not supported for string");
        }

        public String getContentType() {
            return this.contentType();
        }

        public String getName() {
            return "body";
        }

        public /* synthetic */ EmailHandler org$clapper$avsl$handler$EmailHandler$StringDataSource$$$outer() {
            return this.$outer;
        }

        public StringDataSource(EmailHandler $outer, String s) {
            this.s = s;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.contentType = "text/plain";
        }
    }
}

