/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.avsl.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.clapper.avsl.AVSLConfigException;
import org.clapper.avsl.LogLevel;
import org.clapper.avsl.LogMessage;
import org.clapper.avsl.config.ConfiguredArguments;
import org.clapper.avsl.formatter.Formatter;
import org.clapper.avsl.handler.Handler;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001\u0002\u0010 \u0001!B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011)\u0019!C\u0001w!A\u0011\t\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0001D\u0011!A\u0005A!A!\u0002\u0013!\u0005\"B%\u0001\t\u0003Q\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00077\u0002\u0001\u000b\u0011B)\t\u000fq\u0003!\u0019!C\u0001;\"1Q\r\u0001Q\u0001\nyCqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004t\u0001\u0001\u0006I\u0001\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u0019a\b\u0001)A\u0005m\"9Q\u0010\u0001b\u0001\n\u00039\u0007B\u0002@\u0001A\u0003%\u0001\u000eC\u0005\u0000\u0001!\u0015\r\u0011\"\u0003\u0002\u0002!Q\u00111\u0003\u0001\t\u0006\u0004%I!!\u0006\t\u0015\u0005u\u0001\u0001#b\u0001\n\u0013\tyB\u0002\u0004\u0002(\u0001!\u0011\u0011\u0006\u0005\n\u0003\u0007\"\"\u0011!Q\u0001\n!Da!\u0013\u000b\u0005\u0002\u0005\u0015\u0003\"CA')\t\u0007I\u0011AA(\u0011!\t)\u0006\u0006Q\u0001\n\u0005E\u0003bBA,)\u0011\u0005\u0011\u0011\f\u0005\b\u0003O\"B\u0011AA5\u0011\u001d\t\t\b\u0006C\u0001\u0003gBq!!\u001e\u0015\t\u0003\t\u0019\bC\u0004\u0002x\u0001!\t!!\u001f\u0003\u0019\u0015k\u0017-\u001b7IC:$G.\u001a:\u000b\u0005\u0001\n\u0013a\u00025b]\u0012dWM\u001d\u0006\u0003E\r\nA!\u0019<tY*\u0011A%J\u0001\bG2\f\u0007\u000f]3s\u0015\u00051\u0013aA8sO\u000e\u00011c\u0001\u0001*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\u0004\"\u0001M\u0019\u000e\u0003}I!AM\u0010\u0003\u000f!\u000bg\u000e\u001a7fe\u0006!\u0011M]4t!\t)\u0004(D\u00017\u0015\t9\u0014%\u0001\u0004d_:4\u0017nZ\u0005\u0003sY\u00121cQ8oM&<WO]3e\u0003J<W/\\3oiN\f\u0011BZ8s[\u0006$H/\u001a:\u0016\u0003q\u0002\"!P \u000e\u0003yR!AO\u0011\n\u0005\u0001s$!\u0003$pe6\fG\u000f^3s\u0003)1wN]7biR,'\u000fI\u0001\u0006Y\u00164X\r\\\u000b\u0002\tB\u0011QIR\u0007\u0002C%\u0011q)\t\u0002\t\u0019><G*\u001a<fY\u00061A.\u001a<fY\u0002\na\u0001P5oSRtD\u0003B&M\u001b:\u0003\"\u0001\r\u0001\t\u000bM2\u0001\u0019\u0001\u001b\t\u000bi2\u0001\u0019\u0001\u001f\t\u000b\t3\u0001\u0019\u0001#\u0002\rM,g\u000eZ3s+\u0005\t\u0006C\u0001*Z\u001b\u0005\u0019&B\u0001+V\u0003!Ig\u000e^3s]\u0016$(B\u0001,X\u0003\u0011i\u0017-\u001b7\u000b\u0003a\u000bQA[1wCbL!AW*\u0003\u001f%sG/\u001a:oKR\fE\r\u001a:fgN\fqa]3oI\u0016\u0014\b%\u0001\u0006sK\u000eL\u0007/[3oiN,\u0012A\u0018\t\u0004U}\u000b\u0017B\u00011,\u0005\u0015\t%O]1z!\t\u00117-D\u0001V\u0013\t!WKA\u0004BI\u0012\u0014Xm]:\u0002\u0017I,7-\u001b9jK:$8\u000fI\u0001\u000bg6$\boU3sm\u0016\u0014X#\u00015\u0011\u0005%\u0004hB\u00016o!\tY7&D\u0001m\u0015\tiw%\u0001\u0004=e>|GOP\u0005\u0003_.\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qnK\u0001\fg6$\boU3sm\u0016\u0014\b%\u0001\u0005t[R\u0004\bk\u001c:u+\u00051\bc\u0001\u0016xs&\u0011\u0001p\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005)R\u0018BA>,\u0005\rIe\u000e^\u0001\ng6$\b\u000fU8si\u0002\nqa];cU\u0016\u001cG/\u0001\u0005tk\nTWm\u0019;!\u0003\u0015\u0001(o\u001c9t+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005)\u0001&o\u001c9feRLWm]\u0001\bg\u0016\u001c8/[8o+\t\t9\u0002E\u0002c\u00033I1!a\u0007V\u0005\u001d\u0019Vm]:j_:\f\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0016\u0005\u0005\u0005\u0002c\u00012\u0002$%\u0019\u0011QE+\u0003\u0013Q\u0013\u0018M\\:q_J$(\u0001E*ue&tw\rR1uCN{WO]2f'\u0015!\u00121FA\u001c!\u0011\ti#a\r\u000e\u0005\u0005=\"\u0002BA\u0019\u0003\u0017\tA\u0001\\1oO&!\u0011QGA\u0018\u0005\u0019y%M[3diB!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>]\u000b!\"Y2uSZ\fG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW-A\u0001t)\u0011\t9%a\u0013\u0011\u0007\u0005%C#D\u0001\u0001\u0011\u0019\t\u0019E\u0006a\u0001Q\u0006Y1m\u001c8uK:$H+\u001f9f+\t\t\t\u0006\u0005\u0003\u0002.\u0005M\u0013bA9\u00020\u0005a1m\u001c8uK:$H+\u001f9fA\u0005qq-\u001a;J]B,Ho\u0015;sK\u0006lGCAA.!\u0011\ti&a\u0019\u000e\u0005\u0005}#\u0002BA1\u0003\u0017\t!![8\n\t\u0005\u0015\u0014q\f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\bhKR|U\u000f\u001e9viN#(/Z1n)\t\tY\u0007\u0005\u0003\u0002^\u00055\u0014\u0002BA8\u0003?\u0012AbT;uaV$8\u000b\u001e:fC6\fabZ3u\u0007>tG/\u001a8u)f\u0004X\r\u0006\u0002\u0002R\u00059q-\u001a;OC6,\u0017a\u00017pOR1\u00111PAA\u0003\u000b\u00032AKA?\u0013\r\tyh\u000b\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0004v\u0001\r\u0001[\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\t9)\ba\u0001\u0003\u0013\u000b!\u0002\\8h\u001b\u0016\u001c8/Y4f!\r)\u00151R\u0005\u0004\u0003\u001b\u000b#A\u0003'pO6+7o]1hK\u0002")
public class EmailHandler
implements Handler {
    private Properties props;
    private Session session;
    private Transport transport;
    private final Formatter formatter;
    private final LogLevel level;
    private final InternetAddress sender;
    private final Address[] recipients;
    private final String smtpServer;
    private final Option<Object> smtpPort;
    private final String subject;
    private volatile byte bitmap$0;

    @Override
    public Formatter formatter() {
        return this.formatter;
    }

    @Override
    public LogLevel level() {
        return this.level;
    }

    public InternetAddress sender() {
        return this.sender;
    }

    public Address[] recipients() {
        return this.recipients;
    }

    public String smtpServer() {
        return this.smtpServer;
    }

    public Option<Object> smtpPort() {
        return this.smtpPort;
    }

    public String subject() {
        return this.subject;
    }

    private Properties props$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.props = new Properties();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.props;
    }

    private Properties props() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.props$lzycompute() : this.props;
    }

    private Session session$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.session = Session.getDefaultInstance((Properties)this.props(), null);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.session;
    }

    private Session session() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.session$lzycompute() : this.session;
    }

    private Transport transport$lzycompute() {
        EmailHandler emailHandler = this;
        synchronized (emailHandler) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.transport = this.session().getTransport("smtp");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.transport;
    }

    private Transport transport() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.transport$lzycompute() : this.transport;
    }

    @Override
    public void log(String message, LogMessage logMessage) {
        MimeMessage mailMessage = new MimeMessage(this.session());
        MimeMultipart body = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDataHandler(new DataHandler((DataSource)new StringDataSource(this, message)));
        body.addBodyPart((BodyPart)bodyPart);
        mailMessage.setSender((Address)this.sender());
        mailMessage.setFrom((Address)this.sender());
        mailMessage.setRecipients(Message.RecipientType.TO, this.recipients());
        mailMessage.setSubject(this.subject().replaceAll("%l", logMessage.level().label()));
        mailMessage.setContent((Multipart)body);
        mailMessage.addHeaderLine(new StringBuilder(10).append("X-Mailer: ").append(this.getClass().getName()).toString());
        mailMessage.setSentDate(new Date());
        this.transport().connect();
        Transport.send((Message)mailMessage);
        this.transport().close();
    }

    public static final /* synthetic */ int $anonfun$smtpPort$1(String sPort) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sPort))).recover((PartialFunction)new Serializable(null, sPort){
            private static final long serialVersionUID = 0L;
            private final String sPort$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NumberFormatException) {
                    throw new AVSLConfigException(new StringBuilder(15).append("Bad SMTP port: ").append(this.sPort$1).toString());
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NumberFormatException;
                return bl;
            }
            {
                this.sPort$1 = sPort$1;
            }
        }).get());
    }

    public EmailHandler(ConfiguredArguments args, Formatter formatter, LogLevel level) {
        this.formatter = formatter;
        this.level = level;
        this.sender = (InternetAddress)args.get("sender").map((Function1 & Serializable)x$1 -> new InternetAddress(x$1)).getOrElse((Function0 & Serializable)() -> {
            throw new AVSLConfigException("Missing 'sender' for EmailHandler.");
        });
        this.recipients = (Address[])args.get("recipients").map((Function1 & Serializable)x$2 -> (Address[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])InternetAddress.parse((String)x$2, (boolean)true)), (Function1 & Serializable)x$3 -> x$3, ClassTag$.MODULE$.apply(Address.class))).getOrElse((Function0 & Serializable)() -> {
            throw new AVSLConfigException("No recipients specified for email handler.");
        });
        this.smtpServer = args.getOrElse("smtp.server", "localhost");
        this.smtpPort = args.get("smtp.port").map((Function1 & Serializable)sPort -> BoxesRunTime.boxToInteger((int)EmailHandler.$anonfun$smtpPort$1(sPort)));
        this.subject = args.getOrElse("subject", "%l message");
        this.props().put("mail.smtp.host", this.smtpServer());
        this.props().put("mail.smtp.allow8bitmime", "true");
    }

    public class StringDataSource
    implements DataSource {
        private final String s;
        private final String contentType;
        public final /* synthetic */ EmailHandler $outer;

        public String contentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.s.getBytes());
        }

        public OutputStream getOutputStream() {
            throw new IOException("OutputStream not supported for string");
        }

        public String getContentType() {
            return this.contentType();
        }

        public String getName() {
            return "body";
        }

        public /* synthetic */ EmailHandler org$clapper$avsl$handler$EmailHandler$StringDataSource$$$outer() {
            return this.$outer;
        }

        public StringDataSource(EmailHandler $outer, String s) {
            this.s = s;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.contentType = "text/plain";
        }
    }
}

