/*
 * Decompiled with CFR 0.152.
 */
package grizzled.math;

import grizzled.math.stats$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class stats$ {
    public static final stats$ MODULE$;

    static {
        new stats$();
    }

    public <T> double geometricMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        Predef$.MODULE$.require(!itemList.exists((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final Numeric n$1;

            public final boolean apply(T x$1) {
                return this.n$1.toDouble(x$1) <= 0.0;
            }
            {
                this.n$1 = n$1;
            }
        }));
        int n2 = len;
        switch (n2) {
            default: {
                double recip = 1.0 / (double)len;
                double d2 = 1.0;
                d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n, recip){
                    public static final long serialVersionUID = 0L;
                    private final Numeric n$1;
                    private final double recip$1;

                    public final double apply(double a, T b) {
                        return a * package$.MODULE$.pow(this.n$1.toDouble(b), this.recip$1);
                    }
                    {
                        this.n$1 = n$1;
                        this.recip$1 = recip$1;
                    }
                }));
                break;
            }
            case 1: {
                d = n.toDouble(itemList.apply(0));
            }
        }
        return d;
    }

    public <T> double harmonicMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n2 = len;
        switch (n2) {
            default: {
                double d2 = 0.0;
                d = (double)len / BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n){
                    public static final long serialVersionUID = 0L;
                    private final Numeric n$2;

                    public final double apply(double a, T b) {
                        return a + 1.0 / this.n$2.toDouble(b);
                    }
                    {
                        this.n$2 = n$2;
                    }
                }));
                break;
            }
            case 1: {
                d = n.toDouble(itemList.apply(0));
            }
        }
        return d;
    }

    public <T> double arithmeticMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n2 = len;
        switch (n2) {
            default: {
                double d2 = 0.0;
                d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n){
                    public static final long serialVersionUID = 0L;
                    private final Numeric n$3;

                    public final double apply(double a, T b) {
                        return a + this.n$3.toDouble(b);
                    }
                    {
                        this.n$3 = n$3;
                    }
                })) / (double)len;
                break;
            }
            case 1: {
                d = n.toDouble(itemList.apply(0));
            }
        }
        return d;
    }

    public <T> double mean(Seq<T> items, Numeric<T> n) {
        return this.arithmeticMean((Seq<T>)items.toList(), n);
    }

    public <T> double median(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            d = n.toDouble(itemList.apply(0));
        } else {
            List sorted = (List)itemList.sortWith((Function2)new Serializable(n){
                public static final long serialVersionUID = 0L;
                private final Numeric n$4;

                public final boolean apply(T x$5, T x$6) {
                    return this.n$4.compare(x$5, x$6) < 0;
                }
                {
                    this.n$4 = n$4;
                }
            });
            int midpoint = sorted.length() / 2;
            int n2 = len % 2;
            switch (n2) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
                case 1: {
                    d = n.toDouble(sorted.apply(midpoint));
                    break;
                }
                case 0: {
                    d = this.mean((Seq<T>)Predef$.MODULE$.wrapDoubleArray(new double[]{n.toDouble(sorted.apply(midpoint)), n.toDouble(sorted.apply(midpoint - 1))}), (Numeric<T>)Numeric.DoubleIsFractional$.MODULE$);
                }
            }
        }
        return d;
    }

    public <T> List<T> mode(Seq<T> items, Numeric<T> n) {
        List list;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            list = itemList.take(1);
        } else {
            Map m = Map$.MODULE$.empty();
            itemList.foreach((Function1)new Serializable(m){
                public static final long serialVersionUID = 0L;
                private final Map m$1;

                public final Map<T, Object> apply(T t) {
                    return (Map)this.m$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.m$1.getOrElse(t, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })) + 1))));
                }
                {
                    this.m$1 = m$1;
                }
            });
            int n2 = 0;
            int max2 = BoxesRunTime.unboxToInt((Object)m.values().$div$colon((Object)BoxesRunTime.boxToInteger((int)n2), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$8, int x$9) {
                    return this.apply$mcIII$sp(x$8, x$9);
                }

                public int apply$mcIII$sp(int x$8, int x$9) {
                    return package$.MODULE$.max(x$8, x$9);
                }
            }));
            list = ((TraversableOnce)((TraversableLike)m.filter((Function1)new Serializable(max2){
                public static final long serialVersionUID = 0L;
                private final int max$1;

                public final boolean apply(Tuple2<T, Object> tup) {
                    return tup._2$mcI$sp() == this.max$1;
                }
                {
                    this.max$1 = max$1;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final T apply(Tuple2<T, Object> tup) {
                    return (T)tup._1();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
        }
        return list;
    }

    public <T> double populationVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length(), items.toList(), n);
    }

    public <T> double sampleVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length() - 1, items.toList(), n);
    }

    public <T> double populationStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double popStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> T range(Seq<T> items, Numeric<T> n) {
        Object object;
        int n2 = items.length();
        switch (n2) {
            default: {
                Tuple2 tuple2 = new Tuple2(n.fromInt(Integer.MAX_VALUE), n.fromInt(0));
                Tuple2 tuple22 = (Tuple2)items.$div$colon((Object)tuple2, (Function2)new anonfun.3(n));
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    Object min2 = tuple22._1();
                    Object max2 = tuple22._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2(min2, max2);
                    Object min3 = tuple24._1();
                    Object max3 = tuple24._2();
                    object = n.minus(max3, min3);
                    break;
                }
                throw new MatchError((Object)tuple22);
            }
            case 1: {
                object = n.minus(items.apply(0), items.apply(0));
            }
        }
        return (T)object;
    }

    private <T> double calculateVariance(int denominator, List<T> items, Numeric<T> n) {
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 1);
        double mn = this.mean((Seq<T>)itemList, n);
        List deviations = (List)itemList.map((Function1)new Serializable(n, mn){
            public static final long serialVersionUID = 0L;
            private final Numeric n$5;
            private final double mn$1;

            public final double apply(T x$13) {
                return this.n$5.toDouble(x$13) - this.mn$1;
            }
            {
                this.n$5 = n$5;
                this.mn$1 = mn$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return this.sumOfSquares$1(deviations) / (double)denominator;
    }

    private final double sumOfSquares$1(List dList) {
        double d = 0.0;
        return BoxesRunTime.unboxToDouble((Object)dList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double sum, double d) {
                return this.apply$mcDDD$sp(sum, d);
            }

            public double apply$mcDDD$sp(double sum, double d) {
                return sum + d * d;
            }
        }));
    }

    private stats$() {
        MODULE$ = this;
    }
}

