/*
 * Decompiled with CFR 0.152.
 */
package grizzled.math;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class stats$ {
    public static stats$ MODULE$;

    static {
        new stats$();
    }

    public <T> double geometricMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        Predef$.MODULE$.require(!itemList.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)stats$.$anonfun$geometricMean$1(n, x$1))));
        int n2 = len;
        switch (n2) {
            case 1: {
                d = n.toDouble(itemList.head());
                break;
            }
            default: {
                double recip = 1.0 / (double)len;
                double d2 = 1.0;
                d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToDouble((double)stats$.$anonfun$geometricMean$2(n, recip, BoxesRunTime.unboxToDouble((Object)a), b))));
                break;
            }
        }
        return d;
    }

    public <T> double harmonicMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n2 = len;
        switch (n2) {
            case 1: {
                d = n.toDouble(itemList.head());
                break;
            }
            default: {
                double d2 = 0.0;
                d = (double)len / BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToDouble((double)stats$.$anonfun$harmonicMean$1(n, BoxesRunTime.unboxToDouble((Object)a), b))));
                break;
            }
        }
        return d;
    }

    public <T> double arithmeticMean(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n2 = len;
        switch (n2) {
            case 1: {
                d = n.toDouble(itemList.head());
                break;
            }
            default: {
                double d2 = 0.0;
                d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToDouble((double)stats$.$anonfun$arithmeticMean$1(n, BoxesRunTime.unboxToDouble((Object)a), b)))) / (double)len;
                break;
            }
        }
        return d;
    }

    public <T> double mean(Seq<T> items, Numeric<T> n) {
        return this.arithmeticMean((Seq<T>)items.toList(), n);
    }

    public <T> double median(Seq<T> items, Numeric<T> n) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            d = n.toDouble(itemList.head());
        } else {
            List sorted = (List)itemList.sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)stats$.$anonfun$median$1(n, x$5, x$6)));
            int midpoint = sorted.length() / 2;
            int n2 = len % 2;
            switch (n2) {
                case 0: {
                    d = this.mean((Seq<T>)Predef$.MODULE$.wrapDoubleArray(new double[]{n.toDouble(sorted.apply(midpoint)), n.toDouble(sorted.apply(midpoint - 1))}), (Numeric<T>)Numeric.DoubleIsFractional$.MODULE$);
                    break;
                }
                case 1: {
                    d = n.toDouble(sorted.apply(midpoint));
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                }
            }
        }
        return d;
    }

    public <T> List<T> mode(Seq<T> items, Numeric<T> n2) {
        List list;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            list = itemList.take(1);
        } else {
            Map m = (Map)((TraversableLike)itemList.map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), (Object)BoxesRunTime.boxToInteger((int)1)), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7._1()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object n = tuple2._1();
                List counts = (List)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), ((TraversableOnce)counts.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            int max = BoxesRunTime.unboxToInt((Object)m.values().max((Ordering)Ordering.Int$.MODULE$));
            list = ((MapLike)m.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)stats$.$anonfun$mode$5(max, x0$2)))).keys().toList();
        }
        return list;
    }

    public <T> double populationVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length(), items.toList(), n);
    }

    public <T> double sampleVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length() - 1, items.toList(), n);
    }

    public <T> double populationStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double popStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> T range(Seq<T> items, Numeric<T> n) {
        Object object;
        int n2 = items.length();
        switch (n2) {
            case 1: {
                object = n.minus(items.apply(0), items.apply(0));
                break;
            }
            default: {
                Tuple2 tuple2 = new Tuple2(n.fromInt(Integer.MAX_VALUE), n.fromInt(0));
                Tuple2 tuple22 = (Tuple2)items.$div$colon((Object)tuple2, (Function2 & Serializable & scala.Serializable)(tuple, i) -> new Tuple2(n.min(tuple._1(), i), n.max(tuple._1(), i)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Object min = tuple22._1();
                Object max = tuple22._2();
                Tuple2 tuple23 = new Tuple2(min, max);
                Tuple2 tuple24 = tuple23;
                Object min2 = tuple24._1();
                Object max2 = tuple24._2();
                object = n.minus(max2, min2);
                break;
            }
        }
        return (T)object;
    }

    private <T> double calculateVariance(int denominator, List<T> items, Numeric<T> n) {
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 1);
        double mn = this.mean((Seq<T>)itemList, n);
        List deviations = (List)itemList.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)stats$.$anonfun$calculateVariance$2(n, mn, x$12)), List$.MODULE$.canBuildFrom());
        return stats$.sumOfSquares$1(deviations) / (double)denominator;
    }

    public static final /* synthetic */ boolean $anonfun$geometricMean$1(Numeric n$1, Object x$1) {
        return n$1.toDouble(x$1) <= 0.0;
    }

    public static final /* synthetic */ double $anonfun$geometricMean$2(Numeric n$1, double recip$1, double a, Object b) {
        return a * package$.MODULE$.pow(n$1.toDouble(b), recip$1);
    }

    public static final /* synthetic */ double $anonfun$harmonicMean$1(Numeric n$2, double a, Object b) {
        return a + 1.0 / n$2.toDouble(b);
    }

    public static final /* synthetic */ double $anonfun$arithmeticMean$1(Numeric n$3, double a, Object b) {
        return a + n$3.toDouble(b);
    }

    public static final /* synthetic */ boolean $anonfun$median$1(Numeric n$4, Object x$5, Object x$6) {
        return n$4.compare(x$5, x$6) < 0;
    }

    public static final /* synthetic */ boolean $anonfun$mode$5(int max$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int v = tuple2._2$mcI$sp();
        boolean bl = v == max$1;
        return bl;
    }

    private static final double sumOfSquares$1(List dList) {
        double d2 = 0.0;
        return BoxesRunTime.unboxToDouble((Object)dList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(sum, d) -> sum + d * d));
    }

    public static final /* synthetic */ double $anonfun$calculateVariance$2(Numeric n$5, double mn$1, Object x$12) {
        return n$5.toDouble(x$12) - mn$1;
    }

    private stats$() {
        MODULE$ = this;
    }
}

