/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassFinder;
import org.clapper.util.classutil.ClassInfo;

public final class AndClassFilter
implements ClassFilter {
    private List<ClassFilter> filters = new LinkedList<ClassFilter>();

    public AndClassFilter() {
    }

    public AndClassFilter(ClassFilter ... classFilterArray) {
        for (ClassFilter classFilter : classFilterArray) {
            this.addFilter(classFilter);
        }
    }

    public AndClassFilter addFilter(ClassFilter classFilter) {
        this.filters.add(classFilter);
        return this;
    }

    public void removeFilter(ClassFilter classFilter) {
        this.filters.remove(classFilter);
    }

    public Collection<ClassFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public int getTotalFilters() {
        return this.filters.size();
    }

    @Override
    public boolean accept(ClassInfo classInfo, ClassFinder classFinder) {
        ClassFilter classFilter;
        boolean bl = true;
        Iterator<ClassFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (bl = (classFilter = iterator.next()).accept(classInfo, classFinder))) {
        }
        return bl;
    }
}

