/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassInfo;
import org.clapper.util.classutil.ClassInfoClassVisitor;
import org.clapper.util.classutil.ClassUtil;
import org.clapper.util.classutil.ClassUtilException;
import org.clapper.util.io.AndFileFilter;
import org.clapper.util.io.FileFilterMatchType;
import org.clapper.util.io.FileOnlyFilter;
import org.clapper.util.io.RecursiveFileFinder;
import org.clapper.util.io.RegexFileFilter;
import org.clapper.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassFinder {
    private LinkedHashMap<String, File> placesToSearch = new LinkedHashMap();
    private Map<String, ClassInfo> foundClasses = new LinkedHashMap<String, ClassInfo>();
    private static final Logger log = new Logger(ClassFinder.class);

    public void addClassPath() {
        String string = null;
        try {
            string = System.getProperty("java.class.path");
        }
        catch (Exception exception) {
            string = "";
            log.error("Unable to get class path", exception);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            this.add(new File(stringTokenizer.nextToken()));
        }
    }

    public boolean add(File file) {
        boolean bl = false;
        if (ClassUtil.fileCanContainClasses(file)) {
            String string = file.getAbsolutePath();
            if (this.placesToSearch.get(string) == null) {
                this.placesToSearch.put(string, file);
                if (this.isJar(string)) {
                    this.loadJarClassPathEntries(file);
                }
            }
            bl = true;
        }
        return bl;
    }

    public int add(File[] fileArray) {
        int n = 0;
        for (File file : fileArray) {
            if (!this.add(file)) continue;
            ++n;
        }
        return n;
    }

    public int add(Collection<File> collection) {
        int n = 0;
        for (File file : collection) {
            if (!this.add(file)) continue;
            ++n;
        }
        return n;
    }

    public void clear() {
        this.placesToSearch.clear();
        this.foundClasses.clear();
    }

    public int findClasses(Collection<ClassInfo> collection) {
        return this.findClasses(collection, null);
    }

    public int findClasses(Collection<ClassInfo> collection, ClassFilter classFilter) {
        String string;
        int n = 0;
        this.foundClasses.clear();
        for (File object : this.placesToSearch.values()) {
            string = object.getPath();
            log.info("Finding classes in " + string);
            if (this.isJar(string)) {
                this.processJar(string, this.foundClasses);
                continue;
            }
            if (this.isZip(string)) {
                this.processZip(string, this.foundClasses);
                continue;
            }
            this.processDirectory(object, this.foundClasses);
        }
        log.info("Loaded " + this.foundClasses.size() + " classes.");
        for (ClassInfo classInfo : this.foundClasses.values()) {
            string = classInfo.getClassName();
            String string2 = classInfo.getClassLocation().getPath();
            log.debug("Looking at " + string2 + " (" + string + ")");
            if (classFilter == null || classFilter.accept(classInfo, this)) {
                log.debug("Filter accepted " + string);
                ++n;
                collection.add(classInfo);
                continue;
            }
            log.debug("Filter rejected " + string);
        }
        log.info("Returning " + n + " total classes");
        this.foundClasses.clear();
        return n;
    }

    public int findAllSuperClasses(ClassInfo classInfo, Map<String, ClassInfo> map) {
        ClassInfo classInfo2;
        int n = 0;
        String string = classInfo.getSuperClassName();
        if (string != null && (classInfo2 = this.foundClasses.get(string)) != null) {
            map.put(string, classInfo2);
            ++n;
            n += this.findAllSuperClasses(classInfo2, map);
        }
        return n;
    }

    public int findAllInterfaces(ClassInfo classInfo, Map<String, ClassInfo> map) {
        Object object;
        int n = 0;
        String string = classInfo.getSuperClassName();
        if (string != null && (object = this.foundClasses.get(string)) != null) {
            n += this.findAllInterfaces((ClassInfo)((Object)object), map);
        }
        object = classInfo.getInterfaces();
        if (map != null) {
            for (String string2 : object) {
                ClassInfo classInfo2 = this.foundClasses.get(string2);
                if (classInfo2 == null) continue;
                map.put(string2, classInfo2);
                ++n;
                n += this.findAllInterfaces(classInfo2, map);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJar(String string, Map<String, ClassInfo> map) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
            File file = new File(string);
            this.processOpenZip(jarFile, file, (ClassVisitor)new ClassInfoClassVisitor(map, file));
        }
        catch (IOException iOException) {
            log.error("Can't open jar file \"" + string + "\"", iOException);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                log.error("Can't close " + string, iOException);
            }
            jarFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZip(String string, Map<String, ClassInfo> map) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            File file = new File(string);
            this.processOpenZip(zipFile, file, (ClassVisitor)new ClassInfoClassVisitor(map, file));
        }
        catch (IOException iOException) {
            log.error("Can't open jar file \"" + string + "\"", iOException);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                log.error("Can't close " + string, iOException);
            }
            zipFile = null;
        }
    }

    private void processOpenZip(ZipFile zipFile, File file, ClassVisitor classVisitor) {
        String string = file.getPath();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().toLowerCase().endsWith(".class")) continue;
            try {
                log.debug("Loading " + string + "(" + zipEntry.getName() + ")");
                this.loadClassData(zipFile.getInputStream(zipEntry), classVisitor);
            }
            catch (IOException iOException) {
                log.error("Can't open \"" + zipEntry.getName() + "\" in zip file \"" + string + "\": ", iOException);
            }
            catch (ClassUtilException classUtilException) {
                log.error("Can't open \"" + zipEntry.getName() + "\" in zip file \"" + string + "\": ", classUtilException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDirectory(File file, Map<String, ClassInfo> map) {
        RecursiveFileFinder recursiveFileFinder = new RecursiveFileFinder();
        RegexFileFilter regexFileFilter = new RegexFileFilter("\\.class$", FileFilterMatchType.FILENAME);
        AndFileFilter andFileFilter = new AndFileFilter(regexFileFilter, new FileOnlyFilter());
        ArrayList<File> arrayList = new ArrayList<File>();
        recursiveFileFinder.findFiles(file, andFileFilter, arrayList);
        ClassInfoClassVisitor classInfoClassVisitor = new ClassInfoClassVisitor(map, file);
        for (File file2 : arrayList) {
            String string = file2.getPath();
            log.debug("Loading " + file2.getPath());
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                this.loadClassData(fileInputStream, (ClassVisitor)classInfoClassVisitor);
            }
            catch (IOException iOException) {
                log.error("Can't open \"" + string + "\": ", iOException);
            }
            catch (ClassUtilException classUtilException) {
                log.error("Can't open \"" + string + "\": ", classUtilException);
            }
            finally {
                if (fileInputStream == null) continue;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    log.error("Can't close InputStream for \"" + string + "\"", iOException);
                }
            }
        }
    }

    private void loadJarClassPathEntries(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return;
            }
            Map<String, Attributes> map = manifest.getEntries();
            Attributes attributes = manifest.getMainAttributes();
            Set<Object> set = attributes.keySet();
            for (Object object : set) {
                String string;
                String string2 = (String)attributes.get(object);
                if (!object.toString().equals("Class-Path")) continue;
                String string3 = jarFile.getName();
                log.debug("Adding Class-Path from jar " + string3);
                StringBuilder stringBuilder = new StringBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuilder.setLength(0);
                    string = stringTokenizer.nextToken();
                    String string4 = file.getParent();
                    if (string4 != null) {
                        stringBuilder.append(string4);
                        stringBuilder.append(File.separator);
                    }
                    stringBuilder.append(string);
                }
                string = stringBuilder.toString();
                log.debug("From " + string3 + ": " + string);
                this.add(new File(string));
            }
        }
        catch (IOException iOException) {
            log.error("I/O error processing jar file \"" + file.getPath() + "\"", iOException);
        }
    }

    private void loadClassData(InputStream inputStream, ClassVisitor classVisitor) throws ClassUtilException {
        try {
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(classVisitor, ClassInfo.ASM_CR_ACCEPT_CRITERIA);
        }
        catch (Exception exception) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassFinder.cantReadClassStream", "Unable to load class from open input stream", exception);
        }
    }

    private boolean isJar(String string) {
        return string.toLowerCase().endsWith(".jar");
    }

    private boolean isZip(String string) {
        return string.toLowerCase().endsWith(".zip");
    }
}

