/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.clapper.util.classutil.ClassUtilException;
import org.clapper.util.classutil.FieldInfo;
import org.clapper.util.classutil.MethodInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ClassInfo
extends EmptyVisitor {
    static int ASM_CR_ACCEPT_CRITERIA = 0;
    private int modifier = 0;
    private String className = null;
    private String superClassName = null;
    private String[] implementedInterfaces = null;
    private File locationFound = null;
    private Set<FieldInfo> fields = new HashSet<FieldInfo>();
    private Set<MethodInfo> methods = new HashSet<MethodInfo>();

    public ClassInfo(File file) throws ClassUtilException {
        try {
            ClassReader classReader = new ClassReader((InputStream)new FileInputStream(file));
            classReader.accept((ClassVisitor)this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException iOException) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassInfo.cantReadClassFile", "Unable to load class file \"{0}\"", new Object[]{file.getPath()}, iOException);
        }
    }

    public ClassInfo(InputStream inputStream) throws ClassUtilException {
        try {
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept((ClassVisitor)this, ASM_CR_ACCEPT_CRITERIA);
        }
        catch (IOException iOException) {
            throw new ClassUtilException("org.clapper.util.classutil.Bundle", "ClassInfo.cantReadClassStream", "Unable to load class from open input stream", iOException);
        }
    }

    ClassInfo(String string, String string2, String[] stringArray, int n, File file) {
        this.setClassFields(string, string2, stringArray, n, file);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String[] getInterfaces() {
        return this.implementedInterfaces;
    }

    public int getModifier() {
        return this.modifier;
    }

    public File getClassLocation() {
        return this.locationFound;
    }

    public Set<FieldInfo> getFields() {
        return this.fields;
    }

    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this.modifier & 1) != 0) {
            stringBuilder.append("public ");
        }
        if ((this.modifier & 0x400) != 0) {
            stringBuilder.append("abstract ");
        }
        if ((this.modifier & 0x200) != 0) {
            stringBuilder.append("interface ");
        } else {
            stringBuilder.append("class ");
        }
        stringBuilder.append(this.className);
        String string = " ";
        if (this.implementedInterfaces.length > 0) {
            stringBuilder.append(" implements");
            for (String string2 : this.implementedInterfaces) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
            }
        }
        if (this.superClassName != null && !this.superClassName.equals("java.lang.Object")) {
            stringBuilder.append(string);
            stringBuilder.append("extends ");
            stringBuilder.append(this.superClassName);
        }
        return stringBuilder.toString();
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.setClassFields(string, string3, stringArray, n2, null);
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.fields.add(new FieldInfo(n, string, string2, string3, object));
        return null;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.methods.add(new MethodInfo(n, string, string2, string3, stringArray));
        return null;
    }

    private String translateInternalClassName(String string) {
        return string.replaceAll("/", ".");
    }

    private void setClassFields(String string, String string2, String[] stringArray, int n, File file) {
        this.className = this.translateInternalClassName(string);
        this.locationFound = file;
        if (string2 != null && !string2.equals("java/lang/Object")) {
            this.superClassName = this.translateInternalClassName(string2);
        }
        if (stringArray != null) {
            this.implementedInterfaces = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.implementedInterfaces[i] = this.translateInternalClassName(stringArray[i]);
            }
        }
        this.modifier = this.convertAccessMaskToModifierMask(n);
    }

    private int convertAccessMaskToModifierMask(int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x100) != 0) {
            n2 |= 0x100;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        return n2;
    }
}

