/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.clapper.util.classutil.ClassUtil;
import org.clapper.util.logging.Logger;

public class ClassLoaderBuilder {
    private Collection<URL> urlList = new LinkedHashSet<URL>();
    private static final Logger log = new Logger(ClassLoaderBuilder.class);

    public boolean add(File file) {
        boolean bl = false;
        String string = file.getPath();
        try {
            if (ClassUtil.fileCanContainClasses(file)) {
                if (file.isDirectory() && !string.endsWith("/")) {
                    string = string + "/";
                    file = new File(string);
                }
                this.urlList.add(file.toURI().toURL());
                bl = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.error("Unexpected exception", malformedURLException);
        }
        if (!bl) {
            log.debug("Skipping non-jar, non-zip, non-directory \"" + string + "\"");
        }
        return bl;
    }

    public int add(File[] fileArray) {
        int n = 0;
        for (File file : fileArray) {
            if (!this.add(file)) continue;
            ++n;
        }
        return n;
    }

    public int add(Collection<File> collection) {
        int n = 0;
        for (File file : collection) {
            if (!this.add(file)) continue;
            ++n;
        }
        return n;
    }

    public void addClassPath() {
        String string = null;
        try {
            string = System.getProperty("java.class.path");
        }
        catch (Exception exception) {
            string = "";
            log.error("Unable to get class path", exception);
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                this.add(new File(stringTokenizer.nextToken()));
            }
        }
    }

    public void clear() {
        this.urlList.clear();
    }

    public ClassLoader createClassLoader() throws SecurityException {
        return new URLClassLoader(this.urlList.toArray(new URL[this.urlList.size()]), this.getClass().getClassLoader());
    }

    public ClassLoader createClassLoader(ClassLoader classLoader) throws SecurityException {
        return new URLClassLoader(this.urlList.toArray(new URL[this.urlList.size()]), classLoader);
    }
}

