/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.io.File;
import org.clapper.util.classutil.ClassUtilException;

public class ClassUtil {
    static final String BUNDLE_NAME = "org.clapper.util.classutil.Bundle";

    private ClassUtil() {
    }

    public static boolean fileCanContainClasses(File file) {
        boolean bl = false;
        String string = file.getPath();
        if (file.exists()) {
            bl = string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".zip") || file.isDirectory();
        }
        return bl;
    }

    public static String getShortClassName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n != -1 && ++n < string2.length()) {
            string2 = string2.substring(n);
        }
        return string2;
    }

    public static String getShortClassName(Class clazz) {
        return ClassUtil.getShortClassName(clazz.getName());
    }

    public static Object instantiateClass(String string) throws ClassUtilException {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassUtilException("Can't load class " + string, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new ClassUtilException("Can't load class " + string, classCastException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassUtilException("Can't load class " + string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ClassUtilException("Can't load class " + string, instantiationException);
        }
    }
}

