/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.classutil;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassFinder;
import org.clapper.util.classutil.ClassInfo;

public final class OrClassFilter
implements ClassFilter {
    private List<ClassFilter> filters = new LinkedList<ClassFilter>();

    public OrClassFilter() {
    }

    public OrClassFilter(ClassFilter ... classFilterArray) {
        for (ClassFilter classFilter : classFilterArray) {
            this.addFilter(classFilter);
        }
    }

    public OrClassFilter addFilter(ClassFilter classFilter) {
        this.filters.add(classFilter);
        return this;
    }

    public void removeFilter(ClassFilter classFilter) {
        this.filters.remove(classFilter);
    }

    public Collection<ClassFilter> getFilters() {
        return Collections.unmodifiableCollection(this.filters);
    }

    public int getTotalFilters() {
        return this.filters.size();
    }

    @Override
    public boolean accept(ClassInfo classInfo, ClassFinder classFinder) {
        boolean bl = false;
        if (this.filters.size() == 0) {
            bl = true;
        } else {
            ClassFilter classFilter;
            Iterator<ClassFilter> iterator = this.filters.iterator();
            while (iterator.hasNext() && !(bl = (classFilter = iterator.next()).accept(classInfo, classFinder))) {
            }
        }
        return bl;
    }
}

