/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.ParameterHandler;
import org.clapper.util.cmdline.ParameterParser;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.logging.Logger;
import org.clapper.util.misc.BundleUtil;

public abstract class CommandLineUtility {
    private ParameterParser paramParser = null;

    protected CommandLineUtility() {
    }

    public final void execute(String[] stringArray) throws CommandLineException {
        try {
            this.paramParser = new ParameterParser(this.getUsageInfo());
            this.parseParams(stringArray);
            this.runCommand();
        }
        catch (CommandLineUsageException commandLineUsageException) {
            this.usage(commandLineUsageException.getMessage());
            throw commandLineUsageException;
        }
        catch (CommandLineException commandLineException) {
            throw commandLineException;
        }
        catch (Exception exception) {
            throw new CommandLineException(exception);
        }
    }

    protected void parseCustomOption(char c, String string, Iterator<String> iterator) throws CommandLineUsageException, NoSuchElementException {
        throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.parseCustomOption", "(BUG) custom option found, but class {0} provides no parseCustomOption method.", new Object[]{this.getClass().getName()});
    }

    protected void processPostOptionCommandLine(Iterator<String> iterator) throws CommandLineUsageException, NoSuchElementException {
        if (iterator.hasNext()) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.extraParams", "Extra command line parameter(s).");
        }
    }

    protected void getCustomUsageInfo(UsageInfo usageInfo) {
    }

    protected abstract void runCommand() throws CommandLineException;

    protected int parseIntParameter(String string) throws CommandLineUsageException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badIntegerParam", "Bad integer command line parameter \"{0}\"", new Object[]{string});
        }
    }

    protected int parseIntParameter(String string, int n, int n2) throws CommandLineUsageException {
        int n3 = this.parseIntParameter(string);
        if (n3 < n) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{string, String.valueOf(n)});
        }
        if (n3 > n2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{string, String.valueOf(n2)});
        }
        return n3;
    }

    protected int parseIntOptionArgument(char c, String string, String string2) throws CommandLineUsageException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badIntegerOption", "Bad integer command line parameter \"{0}\" for option {1}", new Object[]{string2, this.getOptionStringForError(c, string)});
        }
    }

    protected int parseIntOptionArgument(char c, String string, String string2, int n, int n2) throws CommandLineUsageException {
        int n3 = this.parseIntOptionArgument(c, string, string2);
        if (n3 < n) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(n)});
        }
        if (n3 > n2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooLarge", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(n2)});
        }
        return n3;
    }

    protected float parseFloatParameter(String string) throws CommandLineUsageException {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badFloatParam", "Bad floating point command line parameter \"{0}\"", new Object[]{string});
        }
    }

    protected float parseFloatParameter(String string, float f, float f2) throws CommandLineUsageException {
        float f3 = this.parseFloatParameter(string);
        if (f3 < f) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{string, String.valueOf(f)});
        }
        if (f3 > f2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{string, String.valueOf(f2)});
        }
        return f3;
    }

    protected float parseFloatOptionArgument(char c, String string, String string2) throws CommandLineUsageException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badFloatParam", "Bad floating point command line parameter \"{0}\" for option {1}", new Object[]{string2, this.getOptionStringForError(c, string)});
        }
    }

    protected float parseFloatOptionArgument(char c, String string, String string2, float f, float f2) throws CommandLineUsageException {
        float f3 = this.parseFloatOptionArgument(c, string, string2);
        if (f3 < f) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(f)});
        }
        if (f3 > f2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooLarge", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(f2)});
        }
        return f3;
    }

    protected double parseDoubleParameter(String string) throws CommandLineUsageException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badDoubleParam", "Bad double floating point command line parameter \"{0}\"", new Object[]{string});
        }
    }

    protected double parseDoubleParameter(String string, double d, double d2) throws CommandLineUsageException {
        double d3 = this.parseDoubleParameter(string);
        if (d3 < d) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooSmall", "Numeric parameter {0} is less than the minimum legal value of {1}", new Object[]{string, String.valueOf(d)});
        }
        if (d3 > d2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericParamTooLarge", "Numeric parameter {0} is greater than the maximum legal value of {1}", new Object[]{string, String.valueOf(d2)});
        }
        return d3;
    }

    protected double parseDoubleOptionArgument(char c, String string, String string2) throws CommandLineUsageException {
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badDoubleOption", "Bad double command line parameter \"{0}\" for option {1}", new Object[]{string2, this.getOptionStringForError(c, string)});
        }
    }

    protected double parseDoubleOptionArgument(char c, String string, String string2, double d, double d2) throws CommandLineUsageException {
        double d3 = this.parseDoubleOptionArgument(c, string, string2);
        if (d3 < d) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is less than the minimum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(d)});
        }
        if (d3 > d2) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.numericOptionParamTooSmall", "Numeric parameter {0} for option {1} is greater than the maximum legal value of {2}", new Object[]{string2, this.getOptionStringForError(c, string), String.valueOf(d2)});
        }
        return d3;
    }

    private void parseParams(String[] stringArray) throws CommandLineUsageException {
        ParameterHandler parameterHandler = new ParameterHandler(){

            @Override
            public void parseOption(char c, String string, Iterator<String> iterator) throws CommandLineUsageException, NoSuchElementException {
                if (string != null && string.equals("logging")) {
                    Logger.enableLogging();
                } else {
                    CommandLineUtility.this.parseCustomOption(c, string, iterator);
                }
            }

            @Override
            public void parsePostOptionParameters(Iterator<String> iterator) throws CommandLineUsageException, NoSuchElementException {
                CommandLineUtility.this.processPostOptionCommandLine(iterator);
            }
        };
        this.paramParser.parse(stringArray, parameterHandler);
    }

    private void usage(String string) {
        System.err.println(this.paramParser.getUsageMessage(string, 78));
    }

    private UsageInfo getUsageInfo() {
        UsageInfo usageInfo = new UsageInfo();
        this.getCustomUsageInfo(usageInfo);
        usageInfo.addOption('\u0000', "logging", BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", Locale.getDefault(), "CommandLineUtility.logging", "Enable logging via the java.util.logging API."));
        return usageInfo;
    }

    private String getOptionStringForError(char c, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (string != null) {
            stringBuffer.append("--");
            stringBuffer.append(string);
            bl = true;
        }
        if (c != '\u0000') {
            if (bl) {
                stringBuffer.append(" (");
            }
            stringBuffer.append('-');
            stringBuffer.append(c);
            if (bl) {
                stringBuffer.append(')');
            }
        }
        assert (stringBuffer.length() > 0);
        return stringBuffer.toString();
    }
}

