/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.OptionInfo;
import org.clapper.util.cmdline.ParameterHandler;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.io.WordWrapWriter;
import org.clapper.util.misc.ArrayIterator;
import org.clapper.util.misc.BundleUtil;
import org.clapper.util.text.TextUtil;

public final class ParameterParser {
    private static final int MAX_OPTION_STRING_LENGTH = 35;
    private UsageInfo usageInfo = null;

    public ParameterParser(UsageInfo usageInfo) {
        this.usageInfo = usageInfo;
    }

    public void parse(String[] stringArray, ParameterHandler parameterHandler) throws CommandLineUsageException {
        ArrayIterator<String> arrayIterator = new ArrayIterator<String>(stringArray);
        try {
            while (arrayIterator.hasNext()) {
                String string = arrayIterator.next();
                if (string.charAt(0) != '-') {
                    arrayIterator.previous();
                    break;
                }
                OptionInfo optionInfo = null;
                if (string.length() == 2) {
                    optionInfo = this.usageInfo.getOptionInfo(string.charAt(1));
                } else {
                    if (!string.startsWith("--")) {
                        throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badLongOption", "Option \"{0}\" is not a single-character short option, but it does not start with \"{1}\", as long options must.", new Object[]{string, "--"});
                    }
                    optionInfo = this.usageInfo.getOptionInfo(string.substring(2));
                }
                if (optionInfo == null) {
                    throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.unknownOption", "Unknown option: \"{0}\"", new Object[]{string});
                }
                parameterHandler.parseOption(optionInfo.shortOption, optionInfo.longOption, arrayIterator);
            }
            parameterHandler.parsePostOptionParameters(arrayIterator);
            if (arrayIterator.hasNext()) {
                throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.tooManyParams", "Too many parameters.");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.missingParams", "Missing command line parameter(s).");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.missingParams", "Missing command line parameter(s).");
        }
    }

    public String getUsageMessage(String string) {
        return this.getUsageMessage(string, 0);
    }

    public String getUsageMessage(String string, int n) {
        String string2;
        OptionInfo optionInfo;
        String string3;
        int n2;
        int n3;
        String string4;
        StringWriter stringWriter = new StringWriter();
        int n4 = 0;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = Locale.getDefault();
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        WordWrapWriter wordWrapWriter = new WordWrapWriter((Writer)stringWriter, n);
        if (string != null) {
            wordWrapWriter.println();
            wordWrapWriter.println(string);
            wordWrapWriter.println();
        }
        if ((string4 = this.usageInfo.getCommandName()) != null) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append("java ");
            stringBuffer.append(this.getClass().getName());
        }
        stringBuffer.append(' ');
        stringBuffer.append(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.options1", "[options]"));
        stringBuffer.append(' ');
        String[] stringArray = this.usageInfo.getParameterNames();
        if (stringArray.length > 0) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                stringBuffer.append(' ');
                n2 = 1;
                if (this.usageInfo.parameterIsRequired(stringArray[n3])) {
                    n2 = 0;
                }
                if (n2 != 0) {
                    stringBuffer.append('[');
                }
                stringBuffer.append(stringArray[n3]);
                if (n2 != 0) {
                    stringBuffer.append(']');
                }
                n4 = Math.max(n4, stringArray[n3].length() + 1);
            }
        }
        if ((string3 = this.usageInfo.getUsagePrologue()) != null) {
            wordWrapWriter.println(string3);
        }
        string3 = BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.usage", "Usage:");
        wordWrapWriter.setPrefix(string3 + " ");
        wordWrapWriter.println(stringBuffer.toString());
        wordWrapWriter.setPrefix(null);
        wordWrapWriter.println();
        wordWrapWriter.println(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.options2", "OPTIONS:"));
        wordWrapWriter.println();
        n5 = 2;
        OptionInfo[] optionInfoArray = this.usageInfo.getOptions();
        for (n3 = 0; n3 < optionInfoArray.length; ++n3) {
            optionInfo = optionInfoArray[n3];
            if (optionInfo.explanation == null || optionInfo.longOption == null) continue;
            n2 = 0;
            string2 = "";
            if (optionInfo.shortOption != '\u0000') {
                n2 = 2;
                string2 = ", ";
            }
            if (optionInfo.longOption != null) {
                n2 += string2.length() + "--".length() + optionInfo.longOption.length();
            }
            if (optionInfo.argToken != null) {
                n2 += optionInfo.argToken.length() + 1;
            }
            n5 = Math.max(n5, n2 + 1);
        }
        if (n5 > 35) {
            n5 = 35;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n3 = 0; n3 < optionInfoArray.length; ++n3) {
            optionInfo = optionInfoArray[n3];
            if (optionInfo.explanation == null) continue;
            stringBuffer2.setLength(0);
            string2 = "";
            if (optionInfo.shortOption != '\u0000') {
                stringBuffer2.append('-');
                stringBuffer2.append(optionInfo.shortOption);
                string2 = ", ";
            }
            if (optionInfo.longOption != null) {
                stringBuffer2.append(string2);
                stringBuffer2.append("--");
                stringBuffer2.append(optionInfo.longOption);
            }
            if (optionInfo.argToken != null) {
                stringBuffer2.append(' ');
                stringBuffer2.append(optionInfo.argToken);
            }
            if ((string3 = stringBuffer2.toString()).length() > n5) {
                wordWrapWriter.println(string3);
                wordWrapWriter.setPrefix(this.padString(" ", n5));
            } else {
                wordWrapWriter.setPrefix(this.padString(stringBuffer2.toString(), n5));
            }
            wordWrapWriter.println(optionInfo.explanation);
            wordWrapWriter.setPrefix(null);
        }
        stringArray = this.usageInfo.getParameterNames();
        if (stringArray.length > 0) {
            wordWrapWriter.println();
            wordWrapWriter.println(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.params", "PARAMETERS:"));
            wordWrapWriter.println();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                wordWrapWriter.setPrefix(this.padString(stringArray[n3], n4));
                wordWrapWriter.println(this.usageInfo.getParameterExplanation(stringArray[n3]));
                wordWrapWriter.setPrefix(null);
            }
        }
        if ((string3 = this.usageInfo.getUsageTrailer()) != null) {
            wordWrapWriter.println();
            wordWrapWriter.println(string3);
        }
        wordWrapWriter.flush();
        return stringWriter.toString();
    }

    private String padString(String string, int n) {
        return TextUtil.leftJustifyString(string, n);
    }
}

